<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    // Retrieving data from POST request
    $task_id        = $_POST['task_id'];
    $user_id        = $_POST['user_id'];
    $entry_points   = $_POST['entry_points'];
    
    // Set start_date to the current date and time
    $start_date     = date('Y-m-d H:i:s');
    // Set start_time to the current time
    $start_time     = date('H:i:s');
    
    // Get task and challenge information
    $task_arr = $general->get_Onerow("tasks", "and task_id=" . $task_id);
    $challenge_arr = $general->get_Onerow("challenges", "and challenge_id=" . $task_arr['challenge_id']);
    $arena = $challenge_arr['arena'];
    
    // NEW: Check if this is a team challenge
    $is_team_challenge = ($challenge_arr['frequency'] === 'team');
    $team_challenge_flag = $is_team_challenge ? 'yes' : 'no';
    
    // Clean up previous task attempts for non-streak challenges
    if ($challenge_arr['frequency'] != "streak")
    {
        $msg = $general->del_Row("user_tasks", "task_id=" . $task_id . " and user_id=" . $user_id);
    }
    
    $challengeIds = $task_arr['challenge_id'];
    $day = $task_arr['day'];
    
    // Handle streak challenges
    if ($challenge_arr['frequency'] == "streak")
    {
        $users_task = $general->getLatestRow("user_tasks", " task_id=" . $task_id);
        if (!empty($users_task))
        {
            $day = $users_task['day'] + 1;
        }
        else
        {
            $day = 1;
        }
    }
    
    // Insert user task record with team challenge flag
    if ($task_arr['task_type'] == "stepCounter")
    {
        $msg = $general->ins_Row(
            'user_tasks',
            'task_id, user_id, entry_points, start_date, start_time, arena, challenge_id, day, completed, team_challenge',
            "'$task_id', '$user_id', '$entry_points', '$start_date', '$start_time', '$arena', '$challengeIds', '$day', 'yes', '$team_challenge_flag'"
        );
    }
    else
    {
        $msg = $general->ins_Row(
            'user_tasks',
            'task_id, user_id, entry_points, start_date, start_time, arena, challenge_id, day, team_challenge',
            "'$task_id', '$user_id', '$entry_points', '$start_date', '$start_time', '$arena', '$challengeIds', '$day', '$team_challenge_flag'"
        );
    }
    
    $userTaskId = $general->get_insetId();
    
    $data = array(
        'userTaskId' => $userTaskId,
        'is_team_challenge' => $is_team_challenge
    );
    
    // Handle user_challenges record
    $user_where = " and challenge_id=" . $challengeIds . " and user_id=" . $user_id;
    $user_challenges = $general->get_Onerow("user_challenges", $user_where);
    
    if (empty($user_challenges))
    {
        $wheres = " and challenge_id=" . $challengeIds;
        $challenges = $general->get_Onerow("challenges", $wheres);
        $reward_points = $challenges['reward_points'];
        $arena = $challenges['arena'];
        $visit = $challenges['visit'];
        $page_ids = $challenges['page_id'];
        
        // NEW: Add team_challenge flag to user_challenges table
        $msg2 = $general->ins_Row(
            'user_challenges',
            'challenge_id, user_id, reward_points, arena, page_id, visit, team_challenge',
            "'$challengeIds', '$user_id', '$reward_points', '$arena', '$page_ids', '$visit', '$team_challenge_flag'"
        );
    }
    else if ($is_team_challenge)
    {
        // NEW: If user_challenges exists but doesn't have team flag, update it
        $update_msg = $general->upd_Row(
            'user_challenges',
            "team_challenge='yes'",
            "challenge_id='$challengeIds' AND user_id='$user_id'"
        );
    }
    
    // NEW: For team challenges, verify user is actually assigned to this task
    if ($is_team_challenge)
    {
        $team_member = $general->get_Onerow("team_members", 
            " and challenge_id=" . $challengeIds . " and user_id=" . $user_id . " and task_id=" . $task_id . " and status='active'");
        
        if (empty($team_member))
        {
            // User is not assigned to this specific task in the team
            echo json_encode([
                'error' => 'You are not assigned to this task in the team challenge',
                'is_team_challenge' => true
            ]);
            exit;
        }
        
        // Optional: Update team member status to indicate task has been started
        $general->upd_Row(
            'team_members',
            "task_status='in_progress'",
            "challenge_id='$challengeIds' AND user_id='$user_id' AND task_id='$task_id'"
        );
    }
    
    if (empty($msg))
    {
        // Successful task entry
        echo json_encode([
            'success' => true, 
            'task' => $data,
            'is_team_challenge' => $is_team_challenge,
            'challenge_frequency' => $challenge_arr['frequency']
        ]);
    }
    else
    {
        // Task entry failed
        echo json_encode([
            'error' => $msg,
            'is_team_challenge' => $is_team_challenge
        ]);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>