<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : null;

    if ($user_id)
    {
        $data = array();
        // Retrieve last login information
        $lastLoginInfo = $general->getLatestRow("user_login", "user_id = $user_id", "login_date", "DESC", 1);
        if (empty($lastLoginInfo))
        {
            $data['first_time'] = "yes";
            $data['already_logged'] = "no";

            $reward_points = 1;
            $streak_cycle = 1;
            $msg = $general->ins_Row(
                'user_login',
                'streak_cycle ,user_id,reward_points',
                "'$streak_cycle','$user_id','$reward_points'"
            );
            $data['login_count'] = 1;
        }
        else
        {
            $data['first_time'] = "no";
            $data['already_logged'] = "no";

            $current_streak_cycle = $lastLoginInfo['streak_cycle'];
            $login_date = $lastLoginInfo['login_date']; // Example login date
            $count_current_cycle = $general->get_AllRowscnt("user_login", " and user_id=" . $user_id . " and streak_cycle=" . $current_streak_cycle);

            // Convert the login date to a DateTime object
            $loginDateTime = new DateTime($login_date);

            // Get today's date and yesterday's date
            $today = new DateTime(); // Current date and time
            $yesterday = (new DateTime())->modify('-1 day'); // Yesterday's date and time
            $data['login_count'] = 1;

            // Check if the login date falls within yesterday
            if ($loginDateTime->format('Y-m-d') === $yesterday->format('Y-m-d'))
            {

                if ($count_current_cycle <= 5)
                {
                    $reward_points = $count_current_cycle + 1;
                    $msg = $general->ins_Row(
                        'user_login',
                        'streak_cycle ,user_id,reward_points',
                        "'$current_streak_cycle','$user_id','$reward_points'"
                    );
                    $data['login_count'] = $count_current_cycle + 1;
                }
                elseif ($count_current_cycle === 6)
                {
                    $reward_points = 20;
                    $msg = $general->ins_Row(
                        'user_login',
                        'streak_cycle ,user_id,reward_points',
                        "'$current_streak_cycle','$user_id','$reward_points'"
                    );
                    $data['login_count'] = $count_current_cycle + 1;
                }
                elseif ($count_current_cycle > 6)
                {
                    $reward_points = 1;
                    $streak_cycle = $lastLoginInfo['streak_cycle'] + 1;
                    $msg = $general->ins_Row(
                        'user_login',
                        'streak_cycle ,user_id,reward_points',
                        "'$streak_cycle','$user_id','$reward_points'"
                    );
                    $data['login_count'] = 1;
                }
            }
            elseif ($loginDateTime->format('Y-m-d') === $today->format('Y-m-d'))
            {
                $data['already_logged'] = "yes";
            }
            else
            {
                $reward_points = 1;
                $streak_cycle = $lastLoginInfo['streak_cycle'] + 1;
                $msg = $general->ins_Row(
                    'user_login',
                    'streak_cycle ,user_id,reward_points',
                    "'$streak_cycle','$user_id','$reward_points'"
                );
                $data['login_count'] = 1;
            }
            $data['count'] = $count_current_cycle;

        }
    }
    else
    {
        // Invalid or missing user_id parameter
        http_response_code(400);
        echo json_encode(['error' => 'Invalid or missing user_id parameter']);
    }
    echo json_encode($data);
}
else
{
    // Invalid request method
    http_response_code(405);
    echo json_encode(['error' => 'Method Not Allowed']);
}
