<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if id is provided in the request
    $district_name = isset($_GET['district']) ? $_GET['district'] : null;
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $visit = isset($_GET['visit']) ? $_GET['visit'] : null;

    if ($district_name !== null) {
        // Get the district details
        $where = " and title='" . $district_name . "'";
        $district_details = $general->get_Onerow("districts", $where);

        if (!empty($district_details)) {
            // Get the page details associated with the district
            $where = " and id=" . $district_details['page_id'];
            $event_details = $general->get_Onerow("page", $where);

            // Construct data array with page details
            $data = array();
            $data['title'] = $event_details['title'];
            $data['image'] = $event_details['icon'];
            $data['followers'] = $event_details['followers'];
            $data['following'] = "true"; // Assuming the user is following the page by default
            $data['pageId'] = $event_details['id'];

            // Check if user is following the page
            if (isset($_GET['userId'])) {
                $follow_check = $general->get_Onerow("user_pages", "and page_id=" . $event_details['id'] . " and user_id=" . $_GET['userId']);
                if ($follow_check == "") {
                    $data['following'] = "false";
                    $ins_page_id = $event_details['id'];
                    $ins_type = $event_details['type'];
                    $result = $general->ins_Row(
                        'user_pages',
                        'type, user_id, page_id,movie_id',
                        "'$ins_type', '$userId', '$ins_page_id', '$ins_page_id'"
                    );
                }
            }
            $districts_within_page_cnt = $general->get_AllRowscnt("districts"," and district_id=" . $district_details['district_id']);

            // Get all districts inside the page_id
            $districts_within_page = $general->get_AllRows("districts", 0, $districts_within_page_cnt, "title desc", " and district_id=" . $district_details['district_id']);

            // Initialize districts data array
            $districtsData = array();

            // Iterate over each district and fetch challenges
            foreach ($districts_within_page as $district) {
                $district_id = $district['district_id'];
                $wheres = " and active='yes' and arena='no' and page_id=" . $event_details['id'] . " and district_id=" . $district_id;
                $wheres .= " AND end_date >= NOW()";
                $wheres .= " AND visit = 'yes'";
                
                $challenge_count = $general->get_AllRowscnt("challenges", $wheres);

                if ($challenge_count > 0) {
                    $challenge_arr = $general->get_AllRows("challenges", 0, $challenge_count, "challenge_id desc", $wheres);

                    $challenges_data = array();

                    foreach ($challenge_arr as $key => $val) {
                        // Encode challenge details as JSON
                        $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=".$val['challenge_id']);
                        $open_for = $val['open_for'];
                        if($single_task_cnt ==1)
                        {
                            $single_task = "yes";
                        }
                        else
                        {
                            $single_task = "no";
        
                        }
                        $challenges_data[] = array(
                            'challenge_id' => $val['challenge_id'],
                            'title' => $val['title'],
                            'description' => $general->basedecode($val['description']),
                            'challenge_type' => $val['challenge_type'],
                            'start_date' => $val['start_date'],
                            'start_time' => $val['start_time'],
                            'end_date' => $val['end_date'],
                            'end_time' => $val['end_time'],
                            'frequency' => $val['frequency'],
                            'entry_points' => $val['entry_points'],
                            'reward_points' => $val['reward_points'],
                            'level' => $val['level'],
                            'created_by' => $val['created_by'],
                            'created_date' => $val['created_date'],
                            'visit' => $val['visit'],
                            'participants_count' => $val['participants_count'],
                            'removed_date' => $val['removed_date'],
                            'removed_by' => $val['removed_by'],
                            'days' => $val['days'],
                            'image' => $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id'])['media_path'],
                            'icon' => $event_details['icon'],
                            'page_title' => $district_details['title'],
                            'open_for' => $open_for,
                            'single_task' => $single_task,
                            'completed' => ($general->get_Onerow("user_challenges", " and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId) != "") ? "true" : "false",
                            'finished' => ($general->get_Onerow("user_challenges", " and completed='yes' and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId) != "") ? "true" : "false",
                            'selectedTitle' => array(
                                'title' => $event_details['title'],
                                'image' => $district_details['image']
                            )
                        );
                    }
                   

                    // Add challenges data to the main data array under the current district
                    $districtsData[] = array(
                        'district_id' => $district_id,
                        'title' => $district['title'],
                        'challenges' => $challenges_data
                    );
                } else {
                    // If no challenges found, still add the district entry with an empty array of challenges
                    $districtsData[] = array(
                        'district_id' => $district_id,
                        'title' => $district['title'],
                        'challenges' => []
                    );
                }
            }

            // Reorder districtsData so that the current district comes first
            $current_district_index = array_search($district_details['district_id'], array_column($districtsData, 'district_id'));
            if ($current_district_index !== false) {
                $current_district = $districtsData[$current_district_index];
                unset($districtsData[$current_district_index]);
                array_unshift($districtsData, $current_district);
            }

            // Sort challenges within each district with completed ones going last
            foreach ($districtsData as &$district) {
                usort($district['challenges'], function ($a, $b) {
                    if ($a['completed'] == $b['completed']) {
                        return 0;
                    }
                    return ($a['completed'] < $b['completed']) ? -1 : 1;
                });
            }

            // Add districts data array to the main data array
            $data['districtsData'] = $districtsData;

            // Return JSON response
            echo json_encode($data);
        } else {
            // District not found
            echo json_encode(['error' => 'No challenges found for the specified district']);
        }
    } else {
        // Missing district name parameter
        echo json_encode(['error' => 'Missing district name parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>
