<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $district = isset($_GET['district']) ? $_GET['district'] : null;
    $country = isset($_GET['country']) ? $_GET['country'] : null;

    // Get user's followed pages
    $user_pages_cnt = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId);
    $user_pages_rows = $general->get_AllRows("user_pages", 0, $user_pages_cnt, "id desc", " and user_id=" . $userId);

    $data = array();

    // Fetch posts and challenges from followed pages
    foreach ($user_pages_rows as $user_page)
    {
        $page_id = $user_page['page_id'];

        $posts = fetchPosts($general, $page_id, $userId);
        $challenges = fetchChallenges($general, $page_id, $userId);
        $teamChallenges = fetchTeamChallenges($general, $page_id, $userId); // NEW: Team challenges
        $certificates = fetchCertificates($general, $page_id, $userId);

        $data = array_merge($data, $posts, $challenges, $teamChallenges, $certificates);
    }

    // Fetch location-based pages (Now pages) if district or country is provided
    if ($district || $country) {
        $locationPages = fetchLocationBasedContent($general, $district, $country, $userId);
        $data = array_merge($data, $locationPages);
    }

    // Sort by creation date
    usort($data, function ($a, $b)
    {
        $a_created_at = isset($a['created_at']) ? strtotime($a['created_at']) : 0;
        $b_created_at = isset($b['created_at']) ? strtotime($b['created_at']) : 0;

        return $b_created_at - $a_created_at;
    });

    echo json_encode($data);
}
else
{
    echo json_encode(['error' => 'Invalid request method']);
}

function fetchPosts($general, $page_id, $userId)
{
    $where_posts = " and page_id=" . $page_id;
    $post_count = $general->get_AllRowscnt("posts", $where_posts);
    $posts = $general->get_AllRows("posts", 0, $post_count, "post_id desc", $where_posts);

    $data = array();

    foreach ($posts as $val)
    {
        $page_details = $general->get_Onerow("page", " and id=" . $val['page_id']);
        $post_id = $val['post_id'];
        $page_id = $val['page_id'];
        $count_comment = $general->get_AllRowscnt("post_comments", " and post_id=" . $post_id);

        $where = " and page_id=" . $page_id . " and post_id=" . $post_id . " and user_id=" . $userId;
        $post_likes = $general->get_AllRowscnt("post_likes", $where);
        $already_liked = !empty($post_likes);

        // Check if user is following this page
        $is_following = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId . " and page_id=" . $page_id) > 0;

        $post = array(
            'info_type' => 'post',
            'post_id' => $val['post_id'],
            'type' => $val['type'],
            'video' => $val['video'],
            'image' => $val['image'],
            'textData' => $general->basedecode($val['textData']),
            'caption' => $val['caption'],
            'page_id' => $val['page_id'],
            'page_title' => $page_details['title'],
            'page_icon' => $page_details['icon'],
            'like_count' => $val['like_count'],
            'comment_count' => $count_comment,
            'already_liked' => $already_liked,
            'created_at' => date('d-m-Y H:i:s', strtotime($val['created_at'])),
            'is_now' => false, // Posts from followed pages are not "now" content
            'is_following' => $is_following,
            'page_type' => $page_details['type']
        );
        $data[] = $post;
    }

    return $data;
}

function fetchCertificates($general, $page_id, $userId)
{
    $where_people = " and page_id=" . $page_id;
    $people_count = $general->get_AllRowscnt("people_data", $where_people);
    $people_data = $general->get_AllRows("people_data", 0, $people_count, "created_at desc", $where_people);

    $data = array();

    foreach ($people_data as $val)
    {
        $people_media = $general->get_Onerow("people_media", " and people_data_id=" . $val['id']);
        $page_details = $general->get_Onerow("page", " and id=" . $val['page_id']);
        $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $val['challenge_id']);
        $user_details = $general->get_Onerow("user_details", " and id=" . $val['user_id']);
        $task_details = $general->get_Onerow("tasks", " and task_id=" . $val['task_id']);

        // Check if user is following this page
        $is_following = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId . " and page_id=" . $page_id) > 0;

        $certificate = array(
            'info_type' => 'certificate',
            'id' => $val['id'],
            'challenge_id' => $val['challenge_id'],
            'user_id' => $val['user_id'],
            'task_id' => $val['task_id'],
            'page_id' => $val['page_id'],
            'people_data_id' => $val['id'],
            'like_count' => $val['like_count'],
            'name' => $user_details['name'],
            'user_image' => $user_details['image'],
            'first_character' => strtoupper(substr($user_details['name'], 0, 1)),
            'date' => date('d-m-Y H:i:s', strtotime($val['created_at'])),
            'created_at' => date('d-m-Y H:i:s', strtotime($val['created_at'])),
            'challenge_title' => $challenge_details['title'],
            'page_title' => $page_details['title'],
            'icon' => $page_details['icon'],
            'image2' => $people_media['image'],
            'mediaType' => 'image', // You might need to determine this from the file extension
            'comment_count' => $general->get_AllRowscnt("comments", " and people_id=" . $val['id']),
            'is_now' => false, // Certificates from followed pages are not "now" content
            'is_following' => $is_following,
            'page_type' => $page_details['type']
        );

        $data[] = $certificate;
    }

    return $data;
}

function fetchChallenges($general, $page_id, $userId)
{
    // Updated to exclude team challenges from regular challenge feed and exclude visit challenges
    $where_challenges = " and frequency<>'quiz' and frequency<>'food' and frequency<>'experience' and frequency<>'team' and open_for ='everyone' and arena='no' and visit='no' and active='yes' and page_id=" . $page_id;
    $challenge_count = $general->get_AllRowscnt("challenges", $where_challenges);
    $challenges = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $where_challenges);

    $data = array();

    foreach ($challenges as $val)
    {
        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
        $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);

        $user_challenges = $general->get_Onerow("user_challenges", "  AND challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
        $challengeComplete = ($user_challenges != "") ? "true" : "false";

        // Check if user is following this page
        $is_following = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId . " and page_id=" . $page_id) > 0;

        $challenge = array(
            'info_type' => 'challenge',
            'challenge_id' => $val['challenge_id'],
            'title' => $val['title'],
            'description' => $general->basedecode($val['description']),
            'challenge_type' => $val['challenge_type'],
            'page_id' => $val['page_id'],
            'start_date' => $val['start_date'],
            'rewards' => $val['rewards'],
            'start_time' => $val['start_time'],
            'end_date' => $val['end_date'],
            'end_time' => $val['end_time'],
            'entry_points' => $val['entry_points'],
            'reward_points' => $val['reward_points'],
            'level' => $val['level'],
            'created_by' => $val['created_by'],
            'created_date' => $val['created_date'],
            'participants_count' => $val['participants_count'],
            'removed_date' => $val['removed_date'],
            'removed_by' => $val['removed_by'],
            'frequency' => $val['frequency'],
            'page_title' => $page_details['title'],
            'icon' => $page_details['icon'],
            'image' => $challenge_media['media_path'],
            'completed' => $challengeComplete,
            'referral_count' => $val['referral_count'],
            'created_at' => date('d-m-Y H:i:s', strtotime($val['start_date'])),
            'user_referral_count' => $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId"),
            'selectedTitle' => array(
                'title' => $page_details['title'],
                'image' => $page_details['icon']
            ),
            'is_now' => false, // Challenges from followed pages are not "now" content
            'is_following' => $is_following,
            'page_type' => $page_details['type']
        );

        $challenge['open_for'] = $val['open_for'];
        $single_task_cnt = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);

        if ($single_task_cnt == 1)
        {
            $challenge['single_task'] = "yes";
        }
        else
        {
            $challenge['single_task'] = "no";
        }

        if($user_challenges=="")
        {
            $data[] = $challenge;
        }
    }

    return $data;
}

// NEW FUNCTION: Fetch team challenges
function fetchTeamChallenges($general, $page_id, $userId)
{
    $where_challenges = " and frequency='team' and open_for ='everyone' and arena='no' and visit='no' and active='yes' and page_id=" . $page_id . " AND end_date >= NOW()";
    $challenge_count = $general->get_AllRowscnt("challenges", $where_challenges);
    $challenges = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $where_challenges);

    $data = array();

    foreach ($challenges as $val)
    {
        // Check if user has already joined this team challenge
        $user_team_member = $general->get_Onerow("team_members", 
            " and challenge_id=" . $val['challenge_id'] . " and user_id=" . $userId . " and status='active'");
        
        // If user has already joined, skip showing this challenge
        if (!empty($user_team_member)) {
            continue;
        }

        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
        $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);

        // Check if user is following this page
        $is_following = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId . " and page_id=" . $page_id) > 0;

        // Get team members info
        $team_members_count = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $val['challenge_id'] . " and status='active'");
        
        $team_members = array();
        if ($team_members_count > 0) {
            $team_members_arr = $general->get_AllRows("team_members", 0, min($team_members_count, 5), "joined_date asc", 
                " and challenge_id=" . $val['challenge_id'] . " and status='active'");
            
            foreach ($team_members_arr as $member) {
                $user_details = $general->get_Onerow("user_details", " and id=" . $member['user_id']);
                if (!empty($user_details)) {
                    $team_member = array(
                        'id' => $member['user_id'],
                        'name' => isset($user_details['name']) ? $user_details['name'] : '',
                        'avatar' => !empty($user_details['image']) ? $user_details['image'] : '',
                        'is_leader' => $member['is_leader'] === 'yes'
                    );
                    $team_members[] = $team_member;
                }
            }
        }

        // Calculate duration in days
        try {
            $start = new DateTime($val['start_date']);
            $end = new DateTime($val['end_date']);
            $duration = $start->diff($end);
            $challenge_duration = $duration->days;
        } catch (Exception $e) {
            $challenge_duration = 30; // default
        }

        // Determine difficulty based on reward points
        if ($val['reward_points'] >= 500) {
            $difficulty = 'Hard';
        } elseif ($val['reward_points'] >= 200) {
            $difficulty = 'Medium';
        } else {
            $difficulty = 'Easy';
        }

        // Team status logic
        $min_members = isset($val['min_members']) ? $val['min_members'] : 2;
        $max_members = isset($val['max_members']) ? $val['max_members'] : 999; // No limit
        $current_members = $team_members_count;
        
        if (strtotime($val['end_date']) < time()) {
            $team_status = 'completed';
        } else {
            if ($current_members >= $min_members) {
                $team_status = 'active';
            } else {
                $team_status = 'forming';
            }
        }

        $challenge = array(
            'info_type' => 'team_challenge',
            'challenge_id' => $val['challenge_id'],
            'title' => $val['title'],
            'description' => $general->basedecode($val['description']),
            'challenge_type' => $val['challenge_type'],
            'page_id' => $val['page_id'],
            'start_date' => $val['start_date'],
            'rewards' => $val['rewards'],
            'start_time' => $val['start_time'],
            'end_date' => $val['end_date'],
            'end_time' => $val['end_time'],
            'entry_points' => $val['entry_points'],
            'reward_points' => $val['reward_points'],
            'level' => $val['level'],
            'created_by' => $val['created_by'],
            'created_date' => $val['created_date'],
            'participants_count' => $val['participants_count'],
            'removed_date' => $val['removed_date'],
            'removed_by' => $val['removed_by'],
            'frequency' => $val['frequency'],
            'page_title' => $page_details['title'],
            'icon' => $page_details['icon'],
            'image' => $challenge_media['media_path'],
            'referral_count' => $val['referral_count'],
            'created_at' => date('d-m-Y H:i:s', strtotime($val['start_date'])),
            'user_referral_count' => $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId"),
            'selectedTitle' => array(
                'title' => $page_details['title'],
                'image' => $page_details['icon']
            ),
            'is_now' => false,
            'is_following' => $is_following,
            'page_type' => $page_details['type'],
            
            // Team-specific fields
            'team_members' => $team_members,
            'current_members' => $current_members,
            'min_members' => $min_members,
            'max_members' => $max_members,
            'team_status' => $team_status,
            'duration' => $challenge_duration,
            'difficulty' => $difficulty,
            'user_joined' => false, // Always false since we filtered out joined challenges
            'completed' => "false" // Team challenges are never marked as completed for feed
        );

        $challenge['open_for'] = $val['open_for'];
        $single_task_cnt = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);

        if ($single_task_cnt == 1)
        {
            $challenge['single_task'] = "yes";
        }
        else
        {
            $challenge['single_task'] = "no";
        }

        // Only show team challenges that are not completed and user hasn't joined
        if ($team_status !== 'completed') {
            $data[] = $challenge;
        }
    }

    return $data;
}

function fetchLocationCertificates($general, $page_id, $userId, $is_now = false)
{
    $where_people = " and page_id=" . $page_id;
    $people_count = $general->get_AllRowscnt("people_data", $where_people);
    $people_data = $general->get_AllRows("people_data", 0, $people_count, "created_at desc", $where_people);

    $data = array();

    foreach ($people_data as $val)
    {
        $people_media = $general->get_Onerow("people_media", " and people_data_id=" . $val['id']);
        $page_details = $general->get_Onerow("page", " and id=" . $val['page_id']);
        $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $val['challenge_id']);
        $user_details = $general->get_Onerow("user_details", " and id=" . $val['user_id']);
        $task_details = $general->get_Onerow("tasks", " and task_id=" . $val['task_id']);

        // Check if user is following this page
        $is_following = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId . " and page_id=" . $page_id) > 0;

        $certificate = array(
            'info_type' => 'certificate',
            'id' => $val['id'],
            'challenge_id' => $val['challenge_id'],
            'user_id' => $val['user_id'],
            'task_id' => $val['task_id'],
            'page_id' => $val['page_id'],
            'people_data_id' => $val['id'],
            'like_count' => $val['like_count'],
            'name' => $user_details['name'],
            'user_image' => $user_details['image'],
            'first_character' => strtoupper(substr($user_details['name'], 0, 1)),
            'date' => date('d-m-Y H:i:s', strtotime($val['created_at'])),
            'created_at' => date('d-m-Y H:i:s', strtotime($val['created_at'])),
            'challenge_title' => $challenge_details['title'],
            'page_title' => $page_details['title'],
            'icon' => $page_details['icon'],
            'image2' => $people_media['image'],
            'mediaType' => 'image', // You might need to determine this from the file extension
            'comment_count' => $general->get_AllRowscnt("comments", " and people_id=" . $val['id']),
            'is_now' => $is_now,
            'is_following' => $is_following,
            'page_type' => $page_details['type']
        );

        $data[] = $certificate;
    }

    return $data;
}

function fetchLocationBasedContent($general, $district, $country, $userId) 
{
    $data = array();
    
    // Find district-based pages
    if ($district) {
        $where_district = " and title='" . $district . "'";
        $district_details = $general->get_Onerow("districts", $where_district);
        
        if (!empty($district_details)) {
            $district_page_id = $district_details['page_id'];
            
            // Get posts from district page
            $district_posts = fetchLocationPosts($general, $district_page_id, $userId, true);
            $data = array_merge($data, $district_posts);
            
            // Get challenges from district page
            $district_challenges = fetchLocationChallenges($general, $district_page_id, $userId, true);
            $data = array_merge($data, $district_challenges);
            
            // Get team challenges from district page
            $district_team_challenges = fetchLocationTeamChallenges($general, $district_page_id, $userId, true);
            $data = array_merge($data, $district_team_challenges);
            
            // Get people_data (certificates) from district page
            $district_certificates = fetchLocationCertificates($general, $district_page_id, $userId, true);
            $data = array_merge($data, $district_certificates);
        }
    }
    
    // Find country-based pages (if country is provided)
    if ($country) {
        $where_country = " and title='" . $country . "' and type='places'";
        $country_details = $general->get_Onerow("page", $where_country);
        
        if (!empty($country_details)) {
            $country_page_id = $country_details['id'];
            
            // Get posts from country page
            $country_posts = fetchLocationPosts($general, $country_page_id, $userId, true);
            $data = array_merge($data, $country_posts);
            
            // Get challenges from country page
            $country_challenges = fetchLocationChallenges($general, $country_page_id, $userId, true);
            $data = array_merge($data, $country_challenges);
            
            // Get team challenges from country page
            $country_team_challenges = fetchLocationTeamChallenges($general, $country_page_id, $userId, true);
            $data = array_merge($data, $country_team_challenges);
            
            // Get people_data (certificates) from country page
            $country_certificates = fetchLocationCertificates($general, $country_page_id, $userId, true);
            $data = array_merge($data, $country_certificates);
        }
    }
    
    return $data;
}

function fetchLocationPosts($general, $page_id, $userId, $is_now = false)
{
    $where_posts = " and page_id=" . $page_id;
    $post_count = $general->get_AllRowscnt("posts", $where_posts);
    $posts = $general->get_AllRows("posts", 0, $post_count, "post_id desc", $where_posts);

    $data = array();

    foreach ($posts as $val)
    {
        $page_details = $general->get_Onerow("page", " and id=" . $val['page_id']);
        $post_id = $val['post_id'];
        $count_comment = $general->get_AllRowscnt("post_comments", " and post_id=" . $post_id);

        $where = " and page_id=" . $page_id . " and post_id=" . $post_id . " and user_id=" . $userId;
        $post_likes = $general->get_AllRowscnt("post_likes", $where);
        $already_liked = !empty($post_likes);

        // Check if user is following this page
        $is_following = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId . " and page_id=" . $page_id) > 0;

        $post = array(
            'info_type' => 'post',
            'post_id' => $val['post_id'],
            'type' => $val['type'],
            'video' => $val['video'],
            'image' => $val['image'],
            'textData' => $general->basedecode($val['textData']),
            'caption' => $val['caption'],
            'page_id' => $val['page_id'],
            'page_title' => $page_details['title'],
            'page_icon' => $page_details['icon'],
            'like_count' => $val['like_count'],
            'comment_count' => $count_comment,
            'already_liked' => $already_liked,
            'created_at' => date('d-m-Y H:i:s', strtotime($val['created_at'])),
            'is_now' => $is_now,
            'is_following' => $is_following,
            'page_type' => $page_details['type']
        );
        $data[] = $post;
    }

    return $data;
}

function fetchLocationChallenges($general, $page_id, $userId, $is_now = false)
{
    $where_challenges = " and frequency<>'quiz' and frequency<>'food' and frequency<>'experience' and frequency<>'team' and open_for ='everyone' and arena='no' and visit='no' and active='yes' and page_id=" . $page_id;
    $challenge_count = $general->get_AllRowscnt("challenges", $where_challenges);
    $challenges = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $where_challenges);

    $data = array();

    foreach ($challenges as $val)
    {
        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
        $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);

        $user_challenges = $general->get_Onerow("user_challenges", "  AND challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
        $challengeComplete = ($user_challenges != "") ? "true" : "false";

        // Check if user is following this page
        $is_following = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId . " and page_id=" . $page_id) > 0;

        $challenge = array(
            'info_type' => 'challenge',
            'challenge_id' => $val['challenge_id'],
            'title' => $val['title'],
            'description' => $general->basedecode($val['description']),
            'challenge_type' => $val['challenge_type'],
            'page_id' => $val['page_id'],
            'start_date' => $val['start_date'],
            'rewards' => $val['rewards'],
            'start_time' => $val['start_time'],
            'end_date' => $val['end_date'],
            'end_time' => $val['end_time'],
            'entry_points' => $val['entry_points'],
            'reward_points' => $val['reward_points'],
            'level' => $val['level'],
            'created_by' => $val['created_by'],
            'created_date' => $val['created_date'],
            'participants_count' => $val['participants_count'],
            'removed_date' => $val['removed_date'],
            'removed_by' => $val['removed_by'],
            'frequency' => $val['frequency'],
            'page_title' => $page_details['title'],
            'icon' => $page_details['icon'],
            'image' => $challenge_media['media_path'],
            'completed' => $challengeComplete,
            'referral_count' => $val['referral_count'],
            'created_at' => date('d-m-Y H:i:s', strtotime($val['start_date'])),
            'user_referral_count' => $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId"),
            'selectedTitle' => array(
                'title' => $page_details['title'],
                'image' => $page_details['icon']
            ),
            'is_now' => $is_now,
            'is_following' => $is_following,
            'page_type' => $page_details['type']
        );

        $challenge['open_for'] = $val['open_for'];
        $single_task_cnt = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);

        if ($single_task_cnt == 1)
        {
            $challenge['single_task'] = "yes";
        }
        else
        {
            $challenge['single_task'] = "no";
        }

        if($user_challenges=="")
        {
            $data[] = $challenge;
        }
    }

    return $data;
}

// NEW FUNCTION: Fetch location-based team challenges
function fetchLocationTeamChallenges($general, $page_id, $userId, $is_now = false)
{
    $where_challenges = " and frequency='team' and open_for ='everyone' and arena='no' and visit='no' and active='yes' and page_id=" . $page_id . " AND end_date >= NOW()";
    $challenge_count = $general->get_AllRowscnt("challenges", $where_challenges);
    $challenges = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $where_challenges);

    $data = array();

    foreach ($challenges as $val)
    {
        // Check if user has already joined this team challenge
        $user_team_member = $general->get_Onerow("team_members", 
            " and challenge_id=" . $val['challenge_id'] . " and user_id=" . $userId . " and status='active'");
        
        // If user has already joined, skip showing this challenge
        if (!empty($user_team_member)) {
            continue;
        }

        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
        $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);

        // Check if user is following this page
        $is_following = $general->get_AllRowscnt("user_pages", " and user_id=" . $userId . " and page_id=" . $page_id) > 0;

        // Get team members info
        $team_members_count = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $val['challenge_id'] . " and status='active'");
        
        $team_members = array();
        if ($team_members_count > 0) {
            $team_members_arr = $general->get_AllRows("team_members", 0, min($team_members_count, 5), "joined_date asc", 
                " and challenge_id=" . $val['challenge_id'] . " and status='active'");
            
            foreach ($team_members_arr as $member) {
                $user_details = $general->get_Onerow("user_details", " and id=" . $member['user_id']);
                if (!empty($user_details)) {
                    $team_member = array(
                        'id' => $member['user_id'],
                        'name' => isset($user_details['name']) ? $user_details['name'] : '',
                        'avatar' => !empty($user_details['image']) ? $user_details['image'] : '',
                        'is_leader' => $member['is_leader'] === 'yes'
                    );
                    $team_members[] = $team_member;
                }
            }
        }

        // Calculate duration in days
        try {
            $start = new DateTime($val['start_date']);
            $end = new DateTime($val['end_date']);
            $duration = $start->diff($end);
            $challenge_duration = $duration->days;
        } catch (Exception $e) {
            $challenge_duration = 30; // default
        }

        // Determine difficulty based on reward points
        if ($val['reward_points'] >= 500) {
            $difficulty = 'Hard';
        } elseif ($val['reward_points'] >= 200) {
            $difficulty = 'Medium';
        } else {
            $difficulty = 'Easy';
        }

        // Team status logic
        $min_members = isset($val['min_members']) ? $val['min_members'] : 2;
        $max_members = isset($val['max_members']) ? $val['max_members'] : 999; // No limit
        $current_members = $team_members_count;
        
        if (strtotime($val['end_date']) < time()) {
            $team_status = 'completed';
        } else {
            if ($current_members >= $min_members) {
                $team_status = 'active';
            } else {
                $team_status = 'forming';
            }
        }

        $challenge = array(
            'info_type' => 'team_challenge',
            'challenge_id' => $val['challenge_id'],
            'title' => $val['title'],
            'description' => $general->basedecode($val['description']),
            'challenge_type' => $val['challenge_type'],
            'page_id' => $val['page_id'],
            'start_date' => $val['start_date'],
            'rewards' => $val['rewards'],
            'start_time' => $val['start_time'],
            'end_date' => $val['end_date'],
            'end_time' => $val['end_time'],
            'entry_points' => $val['entry_points'],
            'reward_points' => $val['reward_points'],
            'level' => $val['level'],
            'created_by' => $val['created_by'],
            'created_date' => $val['created_date'],
            'participants_count' => $val['participants_count'],
            'removed_date' => $val['removed_date'],
            'removed_by' => $val['removed_by'],
            'frequency' => $val['frequency'],
            'page_title' => $page_details['title'],
            'icon' => $page_details['icon'],
            'image' => $challenge_media['media_path'],
            'referral_count' => $val['referral_count'],
            'created_at' => date('d-m-Y H:i:s', strtotime($val['start_date'])),
            'user_referral_count' => $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId"),
            'selectedTitle' => array(
                'title' => $page_details['title'],
                'image' => $page_details['icon']
            ),
            'is_now' => $is_now,
            'is_following' => $is_following,
            'page_type' => $page_details['type'],
            
            // Team-specific fields
            'team_members' => $team_members,
            'current_members' => $current_members,
            'min_members' => $min_members,
            'max_members' => $max_members,
            'team_status' => $team_status,
            'duration' => $challenge_duration,
            'difficulty' => $difficulty,
            'user_joined' => false, // Always false since we filtered out joined challenges
            'completed' => "false" // Team challenges are never marked as completed for feed
        );

        $challenge['open_for'] = $val['open_for'];
        $single_task_cnt = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);

        if ($single_task_cnt == 1)
        {
            $challenge['single_task'] = "yes";
        }
        else
        {
            $challenge['single_task'] = "no";
        }

        // Only show team challenges that are not completed and user hasn't joined
        if ($team_status !== 'completed') {
            $data[] = $challenge;
        }
    }

    return $data;
}