<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get required parameters
    $task_id = isset($_GET['task_id']) ? $_GET['task_id'] : null;
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

    if ($task_id === null || $user_id === null) {
        echo json_encode(['error' => 'Missing required parameters. Both task_id and user_id are required.']);
        exit;
    }

    // Check if user has completed the task
    $user_task_where = " and task_id=" . $task_id . " and user_id=" . $user_id . " and completed='yes'";
    $user_task = $general->get_Onerow("user_tasks", $user_task_where);

    // if (empty($user_task)) {
    //     echo json_encode(['error' => 'Task not completed by this user.']);
    //     exit;
    // }

    // Get task details
    $task_where = " and task_id=" . $task_id;
    $task = $general->get_Onerow("tasks", $task_where);
    
    if (empty($task)) {
        echo json_encode(['error' => 'Task not found.']);
        exit;
    }

    // Get challenge details
    $challenge_id = $task['challenge_id'];
    $challenge_where = " and challenge_id=" . $challenge_id;
    $challenge = $general->get_Onerow("challenges", $challenge_where);
    
    if (empty($challenge)) {
        echo json_encode(['error' => 'Challenge not found.']);
        exit;
    }

    // Get page details
    $page_id = $challenge['page_id'];
    $page_where = " and id=" . $page_id;
    $page = $general->get_Onerow("page", $page_where);
    
    if (empty($page)) {
        echo json_encode(['error' => 'Page not found.']);
        exit;
    }

    // Get user details
    $user_where = " and id=" . $user_id;
    $user = $general->get_Onerow("user_details", $user_where);
    
    if (empty($user)) {
        echo json_encode(['error' => 'User not found.']);
        exit;
    }

    // Get task media (image)
    $task_media = $general->get_Onerow("task_media", " and task_id=" . $task_id);
    $task_image = !empty($task_media) ? $task_media['media_path'] : null;

    // Get challenge media (as fallback if task has no media)
    $challenge_media = $general->get_Onerow("challenge_media", " and challenge_id=" . $challenge_id);
    $challenge_image = !empty($challenge_media) ? $challenge_media['media_path'] : null;

    // Build the certificate data structure
    $certificate = [
        'certificate_id' => $task_id, // Using user_task ID as certificate ID
        'task_id' => $task_id,
        'challenge_id' => $challenge_id,
        'user_id' => $user_id,
        'completion_date' => date('Y-m-d H:i:s'),
        'issue_date' => date('Y-m-d H:i:s'), // Current timestamp as issue date
        
        // User details
        'name' => $user['name'],
        'image' => $user['image'],
        'first_character' => substr($user['name'], 0, 1),
        
        // Task details
        'task_name' => $task['task_name'],
        'task_description' => $general->basedecode($task['description']),
        'task_image' => $task_image,
        
        // Challenge details
        'challenge_title' => $challenge['title'],
        'challenge_description' => $general->basedecode($challenge['description']),
        'challenge_image' => $challenge_image,
        'reward_points' => $challenge['reward_points'],
        
        // Page/Organization details
        'page_id' => $page_id,
        'page_title' => $page['title'],
        'page_icon' => $page['icon'],
        'page_banner' => $page['banner'],
        
        // Certificate display image (use task image, challenge image, or page banner in that order)
        'certificate_image' => $task_image ?: ($challenge_image ?: $page['banner']),
        
        // Additional metadata
        'completed' => 'yes',
        'end_date' => date('Y-m-d H:i:s') // When the user completed the task
    ];

    echo json_encode(['success' => true, 'data' => $certificate]);
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method. Use GET.']);
}