<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get user ID from request
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;

    if ($userId !== null) {
        // Helper functions for time calculations
        function calculateTimeDuration($startDateTime, $endDateTime) {
            // Calculate the difference between start and end date times
            $interval = $startDateTime->diff($endDateTime);

            // Format the time difference
            $format = '';
            if ($interval->d > 0) {
                $format .= $interval->d . ' days ';
            }
            if ($interval->h > 0) {
                $format .= $interval->h . ' hrs ';
            }
            if ($interval->i > 0) {
                $format .= $interval->i . ' minutes ';
            }
            if ($interval->s > 0) {
                $format .= $interval->s . 's';
            }

            return $format;
        }

        function getUserRank($challengeId, $userId) {
            global $general;
            // Fetch all users participating in the challenge
            $challengeUsers = $general->get_AllRows(
                "user_challenges",
                0,
                1000, // Set a reasonable limit
                "end_date, end_time", // Sorting by end date and time to calculate time taken
                " AND challenge_id = $challengeId AND completed='yes'"
            );

            // Calculate time taken by each user and store in an associative array
            $timeTaken = [];
            foreach ($challengeUsers as $user) {
                if (isset($user['end_date']) && isset($user['start_date'])) {
                    $endTime = new DateTime($user['end_date'] . ' ' . ($user['end_time'] ?: '00:00:00'));
                    $startTime = new DateTime($user['start_date'] . ' ' . ($user['start_time'] ?: '00:00:00'));
                    $timeDiff = $startTime->diff($endTime);
                    $timeTaken[$user['user_id']] = $timeDiff->s + $timeDiff->i * 60 + $timeDiff->h * 3600 + $timeDiff->d * 86400;
                }
            }

            // Sort users based on time taken in ascending order
            asort($timeTaken);

            // Find the rank of the target user
            $rank = 1;
            foreach ($timeTaken as $uid => $time) {
                if ($uid == $userId) {
                    break;
                }
                $rank++;
            }

            return $rank;
        }

        // Fetch all completed challenges for the user
        $where = " AND completed='yes' AND user_id=" . $userId;
        $userChallengesCount = $general->get_AllRowscnt("user_challenges", $where);
        
        $data = array();
        $challenge = array();

        if ($userChallengesCount > 0) {
            $userChallenges = $general->get_AllRows("user_challenges", 0, $userChallengesCount, "end_date DESC", $where);
            
            foreach ($userChallenges as $key => $userChallenge) {
                $challengeId = $userChallenge['challenge_id'];
                
                // Get challenge details
                $challengeDetails = $general->get_Onerow("challenges", " and challenge_id=" . $challengeId);
                
                if (!empty($challengeDetails)) {
                    // Create challenge data
                    $challenge[$key]['page_id'] = $challengeDetails['page_id'];
                    $challenge[$key]['challenge_id'] = $challengeDetails['challenge_id'];
                    $challenge[$key]['title'] = $challengeDetails['title'];
                    $challenge[$key]['description'] = $general->basedecode($challengeDetails['description']);
                    $challenge[$key]['challenge_type'] = $challengeDetails['challenge_type'];
                    $challenge[$key]['start_date'] = $challengeDetails['start_date'];
                    $challenge[$key]['start_time'] = $challengeDetails['start_time'];
                    $challenge[$key]['end_date'] = $challengeDetails['end_date'];
                    $challenge[$key]['end_time'] = $challengeDetails['end_time'];
                    $challenge[$key]['entry_points'] = $challengeDetails['entry_points'];
                    $challenge[$key]['reward_points'] = $challengeDetails['reward_points'];
                    $challenge[$key]['rewards'] = $challengeDetails['rewards'];
                    $challenge[$key]['level'] = $challengeDetails['level'];
                    $challenge[$key]['created_by'] = $challengeDetails['created_by'];
                    $challenge[$key]['created_date'] = $challengeDetails['created_date'];
                    $challenge[$key]['participants_count'] = $challengeDetails['participants_count'];
                    $challenge[$key]['removed_date'] = $challengeDetails['removed_date'];
                    $challenge[$key]['removed_by'] = $challengeDetails['removed_by'];
                    $challenge[$key]['arena'] = $challengeDetails['arena'];
                    $challenge[$key]['open_for'] = $challengeDetails['open_for'];
                    
                    // Check if it's a single task challenge or multiple tasks
                    $single_task_cnt = $general->get_AllRowscnt("tasks", " and challenge_id=" . $challengeId);
                    $challenge[$key]['single_task'] = ($single_task_cnt == 1) ? "yes" : "no";
                    
                    // Get user uploaded media if any
                    $people_media = $general->get_Onerow("people_media", " and challenge_id=" . $challengeId . " and user_id=" . $userId);
                    $challenge[$key]['uploaded_image'] = $people_media ? $people_media['image'] : "";
                    
                    // Get challenge media and page details
                    $challenge_media = $general->get_Onerow("challenge_media", " and challenge_id=" . $challengeId);
                    $page_details = $general->get_Onerow("page", " and id=" . $challengeDetails['page_id']);
                    
                    $challenge[$key]['page_title'] = $page_details['title'];
                    $challenge[$key]['icon'] = $page_details['icon'];
                    $challenge[$key]['image'] = $challenge_media['media_path'];
                    $challenge[$key]['earned_points'] = $userChallenge['reward_points'];
                    
                    // Calculate time spent
                    $startDateTime = new DateTime($userChallenge['start_date']);
                    $endDateTime = new DateTime($userChallenge['end_date']);
                    $challenge[$key]['spend'] = calculateTimeDuration($startDateTime, $endDateTime);
                    
                    // Get user rank
                    $userRank = getUserRank($challengeId, $userId);
                    $challenge[$key]['user_rank'] = $userRank;
                    
                    // Check if user has achievement for this challenge
                    $achievementRow = $general->get_Onerow("achievements", " AND user_id = $userId AND challenge_id = $challengeId");
                    $challenge[$key]['achieved'] = !empty($achievementRow);
                }
            }
        }
        
        $data['challenge'] = $challenge;
        
        echo json_encode(['success' => true, 'data' => $data]);
    } else {
        echo json_encode(['error' => 'Missing userId parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}