<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $page_id = isset($_GET['page_id']) ? $_GET['page_id'] : null;

    if ($userId !== null && $page_id !== null) {
        // Get page information
        $where2 = " and id=" . $page_id;
        $page_info = $general->get_Onerow("page", $where2);
        
        if (empty($page_info)) {
            echo json_encode(['error' => 'Page not found']);
            exit;
        }

        // Get all challenges for this page
        $wheres = " and frequency<> 'quiz' and page_id=$page_id and active='yes' and visit='no' and arena='no'";
        $challenge_count = $general->get_AllRowscnt("challenges", $wheres);
        $challenge_arr = $general->get_AllRows("challenges", 0, $challenge_count, "created_date desc", $wheres);

        $data = array();
        $challenges = array();

        foreach ($challenge_arr as $val) {
            // Check if user has COMPLETED this challenge (completed='yes')
            $user_challenges = $general->get_Onerow(
                "user_challenges", 
                " AND challenge_id=" . $val['challenge_id'] . " AND user_id=" . $userId . " AND completed='yes'"
            );

            // Only proceed if user has completed this challenge
            if (!empty($user_challenges)) {
                // Encode challenge details as JSON
                $challenge = array();
                $challenge['page_id'] = $val['page_id'];
                $challenge['challenge_id'] = $val['challenge_id'];
                $challenge['title'] = $val['title'];
                $challenge['description'] = $general->basedecode($val['description']);
                $challenge['challenge_type'] = $val['challenge_type'];
                $challenge['start_date'] = $val['start_date'];
                $challenge['start_time'] = $val['start_time'];
                $challenge['end_date'] = $val['end_date'];
                $challenge['end_time'] = $val['end_time'];
                $challenge['entry_points'] = $val['entry_points'];
                $challenge['frequency'] = $val['frequency'];
                $challenge['reward_points'] = $val['reward_points'];
                $challenge['level'] = $val['level'];
                $challenge['created_by'] = $val['created_by'];
                $challenge['created_date'] = $val['created_date'];
                $challenge['rewards'] = $val['rewards'];
                $challenge['participants_count'] = $val['participants_count'];
                $challenge['removed_date'] = $val['removed_date'];
                $challenge['removed_by'] = $val['removed_by'];
                $challenge['info_type'] = 'challenge';
                $challenge['days'] = $val['days'];
                $challenge['visit'] = $val['visit'];
                $challenge['referral_count'] = $val['referral_count'];
                $challenge['user_referral_count'] = $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId");
                $challenge['open_for'] = $val['open_for'];
                $challenge['completed'] = "true"; 
                $challenge['completion_date'] = $user_challenges['end_date'];
                $challenge['earned_points'] = $user_challenges['reward_points'];

                $single_task_cnt = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);
                $challenge['single_task'] = ($single_task_cnt == 1) ? "yes" : "no";

                $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                $challenge['image'] = $challenge_media['media_path'];
                
                $page_details = $general->get_Onerow("page", "and id=" . $val['page_id']);
                $challenge['page_title'] = $page_details['title'];
                $challenge['icon'] = $page_details['icon'];

                // Add this completed challenge to the array
                $challenges[] = $challenge;
            }
        }

        // Sort challenges by completion date (if available) or created date
        usort($challenges, function ($a, $b) {
            if (isset($a['completion_date']) && isset($b['completion_date'])) {
                return strtotime($b['completion_date']) - strtotime($a['completion_date']);
            }
            return strtotime($b['created_date']) - strtotime($a['created_date']);
        });

        $data['challenges'] = array_values($challenges);
        $data['state'] = $page_info['title'];

        echo json_encode($data);
    } else {
        echo json_encode(['error' => 'Missing userId or page_id parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}