<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $page_id = isset($_GET['page_id']) ? $_GET['page_id'] : null;
    $current_district_id = isset($_GET['current_district_id']) ? $_GET['current_district_id'] : null;

    if ($userId !== null && $page_id !== null)
    {
        // Get the page details
        $where = " and id=" . $page_id;
        $page_info = $general->get_Onerow("page", $where);

        // Construct data array with page details
        $data = array();
        $data['state'] = $page_info['title'];
        $data['page_id'] = $page_info['id'];
        $data['page_icon'] = $page_info['icon'];

        // Get all districts for this page
        $districts_within_page_cnt = $general->get_AllRowscnt("districts", " and page_id=" . $page_id);
        $districts_within_page = $general->get_AllRows("districts", 0, $districts_within_page_cnt, "", " and page_id=" . $page_id);

        // Initialize districts data array
        $districtsData = array();

        // Iterate over each district and fetch breakfast challenges
        foreach ($districts_within_page as $district)
        {
            $district_id = $district['district_id'];
            
            // Get breakfast challenges for this district with trending data
            $sql = "SELECT c.*, 
                           COALESCE(uc.participation_count, 0) as user_participation_count
                    FROM challenges c 
                    LEFT JOIN (
                        SELECT challenge_id, COUNT(*) as participation_count 
                        FROM user_challenges 
                        GROUP BY challenge_id
                    ) uc ON c.challenge_id = uc.challenge_id
                    WHERE c.frequency='food' 
                    AND c.page_id=" . $page_id . " 
                    AND c.district_id=" . $district_id . "
                    AND c.active='yes' 
                    AND c.visit='no' 
                    AND c.arena='no' 
                    AND c.end_date >= NOW()
                    ORDER BY user_participation_count DESC, c.created_date DESC";
            
            $challenge_arr = $general->get_AllRows_qry($sql);
            $challenges_data = array();

            if (!empty($challenge_arr))
            {
                foreach ($challenge_arr as $val)
                {
                    // Check if user has already completed this challenge
                    $user_challenges = $general->get_Onerow("user_challenges", " AND challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
                    
                    // Only include challenges that user hasn't completed
                    if ($user_challenges == "")
                    {
                        // Encode challenge details as JSON
                        $challenge = array();
                        $challenge['page_id'] = $val['page_id'];
                        $challenge['challenge_id'] = $val['challenge_id'];
                        $challenge['title'] = $val['title'];
                        $challenge['description'] = $general->basedecode($val['description']);
                        $challenge['challenge_type'] = $val['challenge_type'];
                        $challenge['start_date'] = $val['start_date'];
                        $challenge['start_time'] = $val['start_time'];
                        $challenge['end_date'] = $val['end_date'];
                        $challenge['end_time'] = $val['end_time'];
                        $challenge['entry_points'] = $val['entry_points'];
                        $challenge['frequency'] = $val['frequency'];
                        $challenge['reward_points'] = $val['reward_points'];
                        $challenge['level'] = $val['level'];
                        $challenge['created_by'] = $val['created_by'];
                        $challenge['created_date'] = $val['created_date'];
                        $challenge['participants_count'] = $val['participants_count'];
                        $challenge['removed_date'] = $val['removed_date'];
                        $challenge['visit'] = $val['visit'];
                        $challenge['removed_by'] = $val['removed_by'];
                        $challenge['info_type'] = 'challenge';
                        $challenge['days'] = $val['days'];
                        $challenge['referral_count'] = $val['referral_count'];
                        $challenge['user_referral_count'] = $general->get_AllRowscnt("referral_history", " AND referrer_user = $userId");
                        $challenge['open_for'] = $val['open_for'];
                        $challenge['user_participation_count'] = $val['user_participation_count']; // Trending metric
                        
                        // Check if single task
                        $single_task_cnt = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);
                        if ($single_task_cnt == 1)
                        {
                            $challenge['single_task'] = "yes";
                        }
                        else
                        {
                            $challenge['single_task'] = "no";
                        }
                        
                        // Get challenge media
                        $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                        $challenge['image'] = $challenge_media['media_path'];
                        
                        // Page details
                        $challenge['page_title'] = $page_info['title'];
                        $challenge['icon'] = $page_info['icon'];
                        $challenge['completed'] = "false";
                        
                        $challenge['selectedTitle'] = array(
                            'title' => $page_info['title'],
                            'image' => $page_info['icon']
                        );

                        $challenges_data[] = $challenge;
                    }
                }
            }

            // Only add district if it has challenges
            if (!empty($challenges_data))
            {
                $districtsData[] = array(
                    'district_id' => $district_id,
                    'title' => $district['title'],
                    'image' => $district['image'],
                    'challenges' => $challenges_data
                );
            }
        }

        // Sort districts so that the current district comes first (if specified)
        if ($current_district_id !== null)
        {
            usort($districtsData, function ($a, $b) use ($current_district_id)
            {
                if ($a['district_id'] == $current_district_id)
                {
                    return -1;
                }
                elseif ($b['district_id'] == $current_district_id)
                {
                    return 1;
                }
                return 0;
            });
        }

        // Add districts data to response
        $data['districtsData'] = $districtsData;
        
        // Also include a flat list of all challenges for backward compatibility
        $all_challenges = array();
        foreach ($districtsData as $district) {
            $all_challenges = array_merge($all_challenges, $district['challenges']);
        }
        
        // Sort all challenges by trending (participation count) then by created date
        usort($all_challenges, function ($a, $b)
        {
            if ($a['user_participation_count'] != $b['user_participation_count']) {
                return $b['user_participation_count'] - $a['user_participation_count'];
            }
            return strtotime($b['created_date']) - strtotime($a['created_date']);
        });
        
        $data['challenges'] = array_values($all_challenges);

        echo json_encode($data);
    }
    else
    {
        echo json_encode(['error' => 'Missing userId or page_id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>