<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $challenge_id = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    
    if ($challenge_id !== null && $user_id !== null) {
        
        // First, check if user is a member of this team challenge
        $team_member = $general->get_Onerow("team_members", 
            " and challenge_id=" . $challenge_id . " and user_id=" . $user_id . " and status='active'");
        
        if (empty($team_member)) {
            echo json_encode([
                'success' => false,
                'error' => 'User is not a member of this team challenge'
            ]);
            exit;
        }
        
        // Check if user has a task assigned
        if (empty($team_member['task_id'])) {
            echo json_encode([
                'success' => false,
                'error' => 'No task assigned to this user'
            ]);
            exit;
        }
        
        $task_id = $team_member['task_id'];
        
        // Get the task details
        $task_details = $general->get_Onerow("tasks", " and task_id=" . $task_id . " and active='yes'");
        
        if (empty($task_details)) {
            echo json_encode([
                'success' => false,
                'error' => 'Task not found or inactive'
            ]);
            exit;
        }
        
        // Get challenge details
        $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $challenge_id);
        
        if (empty($challenge_details)) {
            echo json_encode([
                'success' => false,
                'error' => 'Challenge not found'
            ]);
            exit;
        }
        
        // Check if user has already completed this task
        $user_task = $general->get_Onerow("user_tasks", 
            " and task_id=" . $task_id . " and user_id=" . $user_id . " and challenge_id=" . $challenge_id);
        
        $task_completed = false;
        if (!empty($user_task) && $user_task['completed'] === 'yes') {
            $task_completed = true;
        }
        
        // Build the task data response
        $data = array();
        
        // Basic task information
        $data['task_id'] = $task_details['task_id'];
        $data['challenge_id'] = $task_details['challenge_id'];
        $data['task_name'] = $task_details['task_name'];
        $data['description'] = $general->basedecode($task_details['description']);
        $data['challenge_type'] = $challenge_details['challenge_type'];
        $data['frequency'] = $challenge_details['frequency'];
        $data['start_date'] = $task_details['start_date'];
        $data['start_time'] = $task_details['start_time'];
        $data['end_date'] = $task_details['end_date'];
        $data['end_time'] = $task_details['end_time'];
        $data['task_type'] = $task_details['task_type'];
        $data['verification_method'] = $task_details['verification_method'];
        $data['entry_points'] = $task_details['entry_points'];
        $data['reward_points'] = $task_details['reward_points'];
        $data['reward_cash'] = $task_details['reward_cash'];
        $data['verification_points'] = $task_details['verification_points'];
        $data['is_certificate'] = $task_details['is_certificate'];
        $data['is_badge'] = $task_details['is_badge'];
        $data['player_level'] = $task_details['player_level'];
        $data['created_date'] = $task_details['created_date'];
        $data['created_by'] = $task_details['created_by'];
        $data['participants_count'] = $task_details['participants_count'];
        $data['active'] = $task_details['active'];
        $data['removed_date'] = $task_details['removed_date'];
        $data['removed_by'] = $task_details['removed_by'];
        
        // Challenge information
        $data['page_id'] = $challenge_details['page_id'];
        $data['challenge_title'] = $challenge_details['title'];
        $data['challenge_description'] = $general->basedecode($challenge_details['description']);
        
        // Task completion status
        $data['completed'] = $task_completed;
        
        // Get task image
        $task_image = $general->get_Onerow("task_media", " and task_id=" . $task_id);
        $data['image'] = !empty($task_image) ? $task_image['media_path'] : '';
        
        // Handle multiple tasks indicator
        $task_relation = $general->get_Onerow("task_relation", " and challenge_id=" . $challenge_id);
        $data['multiple'] = !empty($task_relation) ? "yes" : "no";
        
        // Add task type specific data
        if ($task_details['task_type'] == "stepCounter") {
            $task_pedometer = $general->get_Onerow("task_pedometer", " and task_id=" . $task_id);
            if (!empty($task_pedometer)) {
                $data['steps'] = $task_pedometer['steps'];
                $data['direction'] = $task_pedometer['direction'];
            }
        }
        
        if ($task_details['task_type'] == "mediaCapture") {
            $media_task = $general->get_Onerow("media_tasks", " and task_id=" . $task_id);
            if (!empty($media_task)) {
                $data['media_type'] = $media_task['media_type'];
                $data['title_media'] = $media_task['title'];
            }
        }
        
        if ($task_details['task_type'] == "videoCapture") {
            $media_task = $general->get_Onerow("media_tasks", " and task_id=" . $task_id);
            if (!empty($media_task)) {
                $data['media_type'] = $media_task['media_type'];
                $data['title_media'] = $media_task['title'];
                $data['duration'] = $media_task['duration'];
            }
        }
        
        // Team information
        $data['is_team_challenge'] = true;
        $data['is_leader'] = ($team_member['is_leader'] === 'yes');
        
        // Get team members for context
        $team_members_count = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $challenge_id . " and status='active'");
        
        $team_members = array();
        if ($team_members_count > 0) {
            $team_members_arr = $general->get_AllRows("team_members", 0, $team_members_count, "joined_date asc", 
                " and challenge_id=" . $challenge_id . " and status='active'");
            
            foreach ($team_members_arr as $member) {
                $user_details = $general->get_Onerow("user_details", " and id=" . $member['user_id']);
                if (!empty($user_details)) {
                    $team_member_data = array(
                        'user_id' => $member['user_id'],
                        'name' => $user_details['name'],
                        'avatar' => !empty($user_details['image']) ? $user_details['image'] : '',
                        'is_leader' => ($member['is_leader'] === 'yes'),
                        'task_id' => $member['task_id']
                    );
                    $team_members[] = $team_member_data;
                }
            }
        }
        
        $data['team_members'] = $team_members;
        $data['team_size'] = count($team_members);
        
        echo json_encode([
            'success' => true,
            'task' => $data
        ]);
        
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Missing required parameters: challenge_id and user_id'
        ]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>