<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if id is provided in the request
    $district_name = isset($_GET['district']) ? $_GET['district'] : null;
    $country = isset($_GET['country']) ? $_GET['country'] : null;
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    if ($district_name !== null)
    {
        $where = " and title='" . $district_name . "'";
        $district_details = $general->get_Onerow("districts", $where);

        $data = array();
        if (!empty($district_details))
        {
            $where = " and page_id=" . $district_details['page_id'];
            $challenges_count = $general->get_AllRowscnt("challenges", $where);

            if ($challenges_count > 0)
            {
                $challenge_arr = $general->get_AllRows("challenges", 0, $challenges_count, "created_date desc", $where);


                // Initialize an associative array to store unique page_ids
                $unique_page_ids = array();

                foreach ($challenge_arr as $val)
                {
                    // Check if the page_id is already in the $unique_page_ids array
                    if (!isset($unique_page_ids[$val['page_id']]))
                    {
                        // If not, add it to the $unique_page_ids array
                        $unique_page_ids[$val['page_id']] = true;

                        // Retrieve page details
                        $page_details = $general->get_Onerow("page", " and id=" . $val['page_id']);

                        // Add page details to the $data array
                        $data[] = array(
                            'id' => $page_details['id'],
                            'title' => $page_details['title'],
                            'image' => $page_details['icon'],
                            'type' => $page_details['type'],
                        );
                    }
                }
                // if($country)
                // {
                //     $country = $general->get_Onerow("page", " and title='" . $country."' and type='places'");

                //         $data[] = array(
                //             'id' => $country['id'],
                //             'title' => $country['title'],
                //             'image' => $country['icon'],
                //             'type' => $country['type'],
                //         );
                // }

                // Encode and output the $data array as JSON
                echo json_encode($data);
            }
        }
        else
        {
            echo json_encode(['error' => 'No now found for the specified district_details']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing district name parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
