<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if id is provided in the request
    $district_name = isset($_GET['district']) ? $_GET['district'] : null;
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $visit = isset($_GET['visit']) ? $_GET['visit'] : null;

    if ($district_name !== null)
    {
        $where = " and title='" . $district_name. "'";
        $district_details = $general->get_Onerow("districts", $where);

       

        if (!empty($district_details))
        {
            $where = " and id=" . $district_details['page_id'];

            $event_details = $general->get_Onerow("page", $where);
            $data = array();
            $data['title'] = $event_details['title'];
            $data['image'] = $event_details['icon'];

            $wheres = " and active='yes' and arena='no' and page_id=" . $event_details['id']." and district_id=".$district_details['district_id'];
            $wheres .= " AND end_date >= NOW()";
            if(isset($_GET['visit']))
            {
                $wheres .= " AND visit = 'yes'";

            }
            $challenge_count = $general->get_AllRowscnt("challenges", $wheres);
            $daily_where = " and active='yes' and frequency = 'daily' and page_id=" . $event_details['id'];
            $daily_where .= " and arena='no' AND DATE(start_date) = CURDATE()";
            $daily_count = $general->get_AllRowscnt("challenges", $daily_where);
            $bootcamp_where = " and active='yes' and arena='no' and frequency = 'bootcamp' and page_id=" . $event_details['id'];
            $bootcamp_where .= " AND end_date >= NOW()";
            $bootcamp_count = $general->get_AllRowscnt("challenges", $bootcamp_where);
            $events_arr = $general->get_Onerow("page", "and id=" . $event_details['id']);
            $data['followers'] = $events_arr['followers'];
            $data['title'] = $events_arr['title'];
            $data['following'] = "false";

            if (isset($_GET['userId']))
            {
                $follow_check = $general->get_Onerow("user_pages", "and page_id=" . $event_details['id'] . " and user_id=" . $_GET['userId']);
                if ($follow_check != "")
                {
                    $data['following'] = "true";
                }
            }

            $data['pageId'] = $event_details['id'];
            $challenges = array();

            if ($challenge_count > 0)
            {
                $challenge_arr = $general->get_AllRows("challenges", 0, $challenge_count, "challenge_id desc", $wheres);

                foreach ($challenge_arr as $key => $val)
                {
                    // Encode challenge details as JSON
                    $challenges[$key]['page_id']                = $val['page_id'];
                    $challenges[$key]['challenge_id']           = $val['challenge_id'];
                    $challenges[$key]['title']                  = $val['title'];
                    $challenges[$key]['description']            =  $general->basedecode($val['description']);
                    $challenges[$key]['challenge_type']         = $val['challenge_type'];
                    $challenges[$key]['start_date']             = $val['start_date'];
                    $challenges[$key]['start_time']             = $val['start_time'];
                    $challenges[$key]['end_date']               = $val['end_date'];
                    $challenges[$key]['end_time']               = $val['end_time'];
                    $challenges[$key]['frequency']               = $val['frequency'];
                    $challenges[$key]['entry_points']           = $val['entry_points'];
                    $challenges[$key]['reward_points']          = $val['reward_points'];
                    $challenges[$key]['level']                  = $val['level'];
                    $challenges[$key]['created_by']             = $val['created_by'];
                    $challenges[$key]['created_date']           = $val['created_date'];
                    $challenges[$key]['participants_count']     = $val['participants_count'];
                    $challenges[$key]['removed_date']           = $val['removed_date'];
                    $challenges[$key]['removed_by']             = $val['removed_by'];
                    $challenges[$key]['days'] = $val['days'];
                    $challenges[$key]['open_for'] = $val['open_for'];
                    $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=".$val['challenge_id']);
        
                    if($single_task_cnt ==1)
                    {
                        $challenges[$key]['single_task'] = "yes";
                    }
                    else
                    {
                        $challenges[$key]['single_task'] = "no";
        
                    }
                    $challenge_media                            = $general->get_Onerow("challenge_media", "and challenge_id=" . $val['challenge_id']);
                    $user_challenges                            = $general->get_Onerow("user_challenges", " and challenge_id=" . $val['challenge_id'] . " and user_id =" . $userId);
                    $challenges[$key]['image']                  = $challenge_media['media_path'];
                    $challenges[$key]['icon']                  = $event_details['icon'];
                    $challenges[$key]['page_title']                  = $district_details['title'];
                    if ($user_challenges != "")
                    {
                        $challenges[$key]["completed"] = "true";
                    }
                    else
                    {
                        $challenges[$key]["completed"] = "false";
                    }
                    $selectedTitle = array(
                        'title'      => $event_details['title'],
                        'image'      => $event_details['icon'],
                    );
                    $challenges[$key]['selectedTitle'] = $selectedTitle;

                }

            }
            $data['data'] = $challenges;

            

            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No challenges found for the specified id']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing district name parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
