<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $challenge_id = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;

    if (!$challenge_id) {
        echo json_encode(['error' => 'Missing challenge_id parameter']);
        exit;
    }

    $where = " and challenge_id=" . $challenge_id;

    // Fetch task and challenge data
    $task_arr = $general->get_Onerow("tasks", $where);
    $challenge = $general->get_Onerow("challenges", $where);

    // Check if both records exist
    if (empty($task_arr) || empty($challenge)) {
        echo json_encode(['error' => 'Task or challenge not found']);
        exit;
    }

    $data = array();

    // Get task ID for later queries
    $taskId = isset($task_arr['task_id']) ? $task_arr['task_id'] : null;

    // Add basic task and challenge data if available
    if (isset($challenge['page_id'])) $data['page_id'] = $challenge['page_id'];
    if (isset($task_arr['task_id'])) $data['task_id'] = $task_arr['task_id'];
    if (isset($task_arr['challenge_id'])) $data['challenge_id'] = $task_arr['challenge_id'];
    if (isset($task_arr['task_name'])) $data['task_name'] = $task_arr['task_name'];
    if (isset($task_arr['description'])) $data['description'] = $general->basedecode($task_arr['description']);
    if (isset($challenge['challenge_type'])) $data['challenge_type'] = $challenge['challenge_type'];
    if (isset($challenge['frequency'])) $data['frequency'] = $challenge['frequency'];
    if (isset($task_arr['start_date'])) $data['start_date'] = $task_arr['start_date'];
    if (isset($task_arr['start_time'])) $data['start_time'] = $task_arr['start_time'];
    if (isset($task_arr['end_date'])) $data['end_date'] = $task_arr['end_date'];
    if (isset($task_arr['end_time'])) $data['end_time'] = $task_arr['end_time'];
    if (isset($task_arr['task_type'])) $data['task_type'] = $task_arr['task_type'];
    if (isset($task_arr['verification_method'])) $data['verification_method'] = $task_arr['verification_method'];
    if (isset($task_arr['entry_points'])) $data['entry_points'] = $task_arr['entry_points'];
    if (isset($task_arr['reward_points'])) $data['reward_points'] = $task_arr['reward_points'];
    if (isset($task_arr['reward_cash'])) $data['reward_cash'] = $task_arr['reward_cash'];
    if (isset($task_arr['verification_points'])) $data['verification_points'] = $task_arr['verification_points'];
    if (isset($task_arr['is_certificate'])) $data['is_certificate'] = $task_arr['is_certificate'];
    if (isset($task_arr['is_badge'])) $data['is_badge'] = $task_arr['is_badge'];
    if (isset($task_arr['player_level'])) $data['player_level'] = $task_arr['player_level'];
    if (isset($task_arr['created_date'])) $data['created_date'] = $task_arr['created_date'];
    if (isset($task_arr['created_by'])) $data['created_by'] = $task_arr['created_by'];
    if (isset($task_arr['participants_count'])) $data['participants_count'] = $task_arr['participants_count'];
    if (isset($task_arr['active'])) $data['active'] = $task_arr['active'];
    if (isset($task_arr['removed_date'])) $data['removed_date'] = $task_arr['removed_date'];
    if (isset($task_arr['removed_by'])) $data['removed_by'] = $task_arr['removed_by'];

    // Get task image if available
    if ($taskId) {
        $task_image_arr = $general->get_Onerow("task_media", "and task_id =" . $taskId);
        if (!empty($task_image_arr) && isset($task_image_arr['media_path'])) {
            $data['image'] = $task_image_arr['media_path'];
        } else {
            $data['image'] = null;
        }

        // Check if task is part of a sequence
        $task_relation = $general->get_Onerow("task_relation", $where);
        $data['multiple'] = !empty($task_relation) ? "yes" : "no";

        // Handle different task types with appropriate data
        if (isset($task_arr['task_type'])) {
            // Map task type
            if ($task_arr['task_type'] == "map") {
                $tasksMaps = $general->get_Onerow("task_map", " and task_id=" . $taskId);
                if (!empty($tasksMaps)) {
                    $mapInfo = array();
                    if (isset($tasksMaps['map_id'])) $mapInfo['map_id'] = $tasksMaps['map_id'];
                    if (isset($tasksMaps['task_id'])) $mapInfo['task_id'] = $tasksMaps['task_id'];
                    if (isset($tasksMaps['challenge_id'])) $mapInfo['challenge_id'] = $tasksMaps['challenge_id'];
                    if (isset($tasksMaps['reach_distance'])) $mapInfo['reach_distance'] = $tasksMaps['reach_distance'];
                    if (isset($tasksMaps['latitude'])) $mapInfo['latitude'] = $tasksMaps['latitude'];
                    if (isset($tasksMaps['longitude'])) $mapInfo['longitude'] = $tasksMaps['longitude'];
                    
                    $data['map_info'] = $mapInfo;
                }
            }
            
            // Step counter task type
            elseif ($task_arr['task_type'] == "stepCounter") {
                $task_pedometer = $general->get_Onerow("task_pedometer", " and task_id=" . $taskId);
                if (!empty($task_pedometer)) {
                    if (isset($task_pedometer['steps'])) $data['steps'] = $task_pedometer['steps'];
                    if (isset($task_pedometer['direction'])) $data['direction'] = $task_pedometer['direction'];
                }
            }
            
            // Media capture task type
            elseif ($task_arr['task_type'] == "mediaCapture") {
                $media_tasks = $general->get_Onerow("media_tasks", " and task_id=" . $taskId);
                if (!empty($media_tasks)) {
                    if (isset($media_tasks['media_type'])) $data['media_type'] = $media_tasks['media_type'];
                    if (isset($media_tasks['title'])) $data['title_media'] = $media_tasks['title'];
                }
            }
            
            // Video capture task type
            elseif ($task_arr['task_type'] == "videoCapture") {
                $media_tasks = $general->get_Onerow("media_tasks", " and task_id=" . $taskId);
                if (!empty($media_tasks)) {
                    if (isset($media_tasks['media_type'])) $data['media_type'] = $media_tasks['media_type'];
                    if (isset($media_tasks['title'])) $data['title_media'] = $media_tasks['title'];
                    if (isset($media_tasks['duration'])) $data['duration'] = $media_tasks['duration'];
                }
            }
        }
    }

    echo json_encode($data);
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}