<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    // Check if user_id is provided in the request
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

    if ($user_id !== null)
    {
        $data = array();
        
        // Get only ongoing tasks that can be continued (not locked/pending)
        // This excludes completed tasks and includes only actionable tasks
        $where = " and user_id=" . $user_id." and arena='no' and completed='no'";

        $task = array();
       
        $user_challenges_cnt = $general->get_AllRowscnt("user_challenges", $where);
        if ($user_challenges_cnt > 0)
        {
            $user_challange_arr = $general->get_AllRows("user_challenges", 0, $user_challenges_cnt, "id desc", $where);

            foreach ($user_challange_arr as $key => $val)
            {
                $challenge_array = array();
                $page_array = array();
                $challenges_arr = $general->get_Onerow("challenges", "and challenge_id =" . $val['challenge_id']);
                $page_details = $general->get_Onerow("page", "and id =" . $challenges_arr['page_id']);

                // Check if this task can be continued (not locked)
                $can_continue = false;
                
                // Check if there are pending tasks for this challenge
                $user_task_pending = $general->get_Onerow("user_tasks", " and completed='no' and challenge_id =" . $val['challenge_id'] . " and user_id=" . $user_id);
                
                // Food and experience tasks can always be continued
                if ($challenges_arr['frequency'] == "food" || $challenges_arr['frequency'] == "experience") {
                    $can_continue = true;
                }
                // For other types, check if there are pending tasks
                elseif ($user_task_pending) {
                    $can_continue = true;
                }
                // For bootcamp and streak challenges, check day progression
                elseif ($challenges_arr['frequency'] == "bootcamp" || $challenges_arr['frequency'] == "streak") {
                    $where_user_task = "user_id=".$user_id." AND challenge_id=".$challenges_arr['challenge_id'];
                    $latest_user_task = $general->getLatestRow("user_tasks", $where_user_task, "id", 'DESC', 1);
                    
                    if ($latest_user_task && isset($latest_user_task['day']) && $challenges_arr['days'] > $latest_user_task['day']) {
                        $can_continue = true;
                    }
                }

                // Only include tasks that can be continued
                if ($can_continue) {
                    $task[$key]['page_id'] = $challenges_arr['page_id'];
                    $task[$key]['challenge_id'] = $challenges_arr['challenge_id'];
                    $task[$key]['task_name'] = $challenges_arr['title'];
                    $task[$key]['challenge_type'] = $challenges_arr['challenge_type'];
                    $task[$key]['frequency'] = $challenges_arr['frequency'];
                    $task[$key]['start_date'] = $challenges_arr['start_date'];
                    $task[$key]['start_time'] = $challenges_arr['start_time'];
                    $task[$key]['end_date'] = $challenges_arr['end_date'];
                    $task[$key]['end_time'] = $challenges_arr['end_time'];
                    $task[$key]['entry_points'] = $challenges_arr['entry_points'];
                    $task[$key]['reward_points'] = $challenges_arr['reward_points'];
                    $task[$key]['created_date'] = $challenges_arr['created_date'];
                    $task[$key]['created_by'] = $challenges_arr['created_by'];
                    $task[$key]['removed_date'] = $challenges_arr['removed_date'];
                    $task[$key]['removed_by'] = $challenges_arr['removed_by'];
                    $task[$key]['description'] = $general->basedecode($challenges_arr['description']);
                    
                    $challenge_array['challenge_id'] = $challenges_arr['challenge_id'];
                    $page_array['image'] = $page_details['icon'];
                    $page_array['title'] = $page_details['title'];
                    $page_array['banner'] = $page_details['banner'];
                    $task[$key]['challenge'] = $challenge_array;
                    $task[$key]['selectedMovie'] = $page_array;
                    $task[$key]['challenge_title'] = $challenges_arr['title'];

                    $task_image_arr = $general->get_Onerow("challenge_media", "and challenge_id =" . $val['challenge_id']);
                    $task[$key]['image'] = $task_image_arr['media_path'];
                    
                    // All tasks in ongoing tab should have pending_task = "yes" (can continue)
                    $task[$key]['pending_task'] = "yes";
                }
            }
            
            // Filter out empty entries and reindex array
            $task = array_values(array_filter($task));
            
            $data['tasks'] = $task;
            echo json_encode($data);
        }
        else
        {
            echo json_encode(['error' => 'No ongoing tasks found']);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing user_id parameter']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}