<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    $user_id    = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    $other_user = isset($_GET['other_user']) ? $_GET['other_user'] : null;

    // Only proceed if user_id is provided
    if ($user_id === null) {
        echo json_encode(['error' => 'Missing user_id parameter']);
        exit;
    }

    $where = " and id=" . $user_id;
    $user_details = $general->get_Onerow("user_details", $where);

    // Initialize variables
    $followed_check_user = null;
    $following_check_user = null;
    $following_request_check_user = null;

    if ($other_user) {
        $followed_check = " and user_id=" . $other_user . " and followed_user=" . $user_id;
        $followed_check_user = $general->get_Onerow("user_follow", $followed_check);
        $following_check = " and followed_user=" . $other_user . " and user_id=" . $user_id;
        $following_check_user = $general->get_Onerow("user_follow", $following_check);
        $following_request_check = " and followed_user=" . $other_user . " and user_id=" . $user_id;
        $following_request_check_user = $general->get_Onerow("follow_request", $following_request_check);
    }

    $follow_name = "Follow";
    $streak_day = "no";

    if (!empty($user_details)) {
        $data = array();
        if (!empty($following_check_user) && !empty($followed_check_user)) {
            $follow_name = "Friends";
        } elseif (!empty($following_check_user)) {
            $follow_name = "Following";
        } elseif (!empty($followed_check_user)) {
            $follow_name = "Follow Back";
        }

        if (!empty($following_request_check_user)) {
            $follow_name = "Requested";
        }

        // Check login history for streak
        $lastLoginInfo = $general->getLatestRow("user_login", "user_id = $user_id", "login_date", "DESC", 1);
        if (!empty($lastLoginInfo) && isset($lastLoginInfo['login_date'])) {
            try {
                $login_date = $lastLoginInfo['login_date'];
                $loginDateTime = new DateTime($login_date);
                $today = new DateTime(); // Current date and time
                $yesterday = (new DateTime())->modify('-1 day');
                if ($loginDateTime->format('Y-m-d') === $yesterday->format('Y-m-d')) {
                    $streak_day = "yes";
                }
            } catch (Exception $e) {
                // Handle date parsing errors gracefully
                $streak_day = "no";
            }
        }

        // Get XP data or create if not exists
        $xp_bank_data = $general->get_Onerow("xp_bank", " and user_id = $user_id and page_id=5");
        if (empty($xp_bank_data)) {
            $msg = $general->ins_Row(
                'xp_bank',
                ' user_id, total_xp, page_id',
                " '$user_id', '0', '5'"
            );
            if ($msg == "") {
                $xp_bank_data = $general->get_Onerow("xp_bank", " and user_id = $user_id and page_id=5");
            }
        }

        // Calculate level information
        $level = 1;
        $total_xp = 0;
        $this_level_xp = 0;
        $next_level_xp = 1;
        $percent_to_next_level = 0;

        if (!empty($xp_bank_data) && isset($xp_bank_data['total_xp'])) {
            $total_xp = $xp_bank_data['total_xp'];
            $level_data = $general->get_Onerow("level", " and $total_xp BETWEEN from_xp AND to_xp");

            if (!empty($level_data) && isset($level_data['level']) && isset($level_data['from_xp'])) {
                $level = $level_data['level'];
                $this_level_xp = $level_data['from_xp'];
                $next_level_data = $general->get_Onerow("level", " and level = " . ($level + 1));

                if (!empty($next_level_data) && isset($next_level_data['from_xp'])) {
                    $next_level_xp = $next_level_data['from_xp'];

                    // Calculate percentage towards next level
                    if ($next_level_xp > 0) {
                        $xp_needed_for_next_level = $next_level_xp - $this_level_xp;
                        $percent_to_next_level = intval(($total_xp / $next_level_xp) * 100);
                        // Cap percentage at 100
                        $percent_to_next_level = min(100, $percent_to_next_level);
                    }
                }
            }
        }

        // Set user data
        $data['name'] = isset($user_details['name']) ? $user_details['name'] : '';
        $data['first_character'] = isset($user_details['name']) ? substr($user_details['name'], 0, 1) : '';
        $data['user_image'] = isset($user_details['image']) ? $user_details['image'] : '';
        $data['user_id'] = isset($user_details['id']) ? $user_details['id'] : '';
        $data['gender'] = isset($user_details['gender']) ? $user_details['gender'] : '';
        $data['mobile'] = isset($user_details['mobile']) ? $user_details['mobile'] : '';
        $data['referral_id'] = isset($user_details['referral_id']) ? $user_details['referral_id'] : '';
        $data['account_status'] = isset($user_details['account_status']) ? $user_details['account_status'] : '';
        $data['level'] = $level;
        $data['total_xp'] = $total_xp;
        $data['next_level'] = $level + 1;
        $data['this_level_xp'] = $this_level_xp;
        $data['next_level_xp'] = $next_level_xp;
        $data['percent_to_next_level'] = $percent_to_next_level;
        $data['progress'] = $percent_to_next_level > 0 ? $percent_to_next_level / 100 : 0;
        $data['follow_name'] = $follow_name;
        $data['streak_day'] = $streak_day;

        // Initialize arrays
        $peopleCard = array();
        $user_id = isset($user_details['id']) ? $user_details['id'] : 0;

        // Check if user_id is valid
        if ($user_id > 0) {
            $where = " and user_id=" . $user_id;
            $people_count = $general->get_AllRowscnt("people_data", $where);
            $userpost_count = $general->get_AllRowscnt("user_posts", $where);

            $data['post_count'] = $people_count;

            $where_friends = " and (followed_user=" . $user_id . " OR following_user=" . $user_id . ")";
            $friends_count = $general->get_AllRowscnt("friends", $where_friends);
            $data['friends_count'] = $friends_count;

            $wheres = " and followed_user=" . $user_id;
            $total_following_count = $general->get_AllRowscnt("user_follow", $wheres);
            $data['following'] = $total_following_count;

            $where2 = " and user_id=" . $user_id;
            $total_follower_count = $general->get_AllRowscnt("user_follow", $where2);
            $data['followers'] = $total_follower_count;

            // Fetch people data
            if ($people_count > 0) {
                $people_arr = $general->get_AllRows("people_data", 0, $people_count, "id desc", $where);

                // Track unique challenges to prevent duplicates
                $uniqueChallenges = [];
                $peopleCard = [];
                $indexCounter = 0;

                if (is_array($people_arr)) {
                    foreach ($people_arr as $key => $val2) {
                        if (isset($val2['challenge_id']) && isset($val2['created_at'])) {
                            // Check if the challenge exists
                            $challenge_id = $val2['challenge_id'];
                            $challenge_where = " and challenge_id=" . $challenge_id;
                            $challenge_exists = $general->get_Onerow("challenges", $challenge_where);

                            if (empty($challenge_exists)) {
                                continue; // Skip if challenge doesn't exist
                            }

                            // Create a unique key based on challenge_id and creation date (day)
                            $uniqueKey = $val2['challenge_id'] . '_' . date("Y-m-d", strtotime($val2['created_at']));

                            // Skip this record if we've already processed an identical certificate
                            if (isset($uniqueChallenges[$uniqueKey])) {
                                continue;
                            }

                            // Mark this challenge as processed
                            $uniqueChallenges[$uniqueKey] = true;

                            // Retrieve data from people_media only if it exists
                            $val = isset($val2['id']) ? $general->get_Onerow("people_media", " and people_data_id=" . $val2['id']) : null;
                            $count_comment = isset($val2['id']) ? $general->get_AllRowscnt("comments", " and people_id=" . $val2['id']) : 0;
                            $challenge_media = $challenge_id > 0 ? $general->get_Onerow("challenge_media", "and challenge_id=" . $challenge_id) : null;

                            // Initialize the people card entry
                            $peopleCard[$indexCounter] = [];

                            // Check if $val is not empty before accessing its properties
                            if (!empty($val)) {
                                $peopleCard[$indexCounter]['id'] = isset($val['id']) ? $val['id'] : '';
                                $peopleCard[$indexCounter]['caption'] = isset($val['caption']) ? $val['caption'] : '';
                                $peopleCard[$indexCounter]['image'] = isset($val['image']) ? $val['image'] : '';
                            } else {
                                $peopleCard[$indexCounter]['image'] = !empty($challenge_media) && isset($challenge_media['media_path']) ? $challenge_media['media_path'] : '';
                            }

                            $people_id = isset($val2['id']) ? $val2['id'] : 0;
                            $page_id = isset($val2['page_id']) ? $val2['page_id'] : 0;

                            // Set people card data
                            $peopleCard[$indexCounter]['date'] = isset($val2['created_at']) ? date("M d, Y \a\\t g:i A", strtotime($val2['created_at'])) : '';
                            $peopleCard[$indexCounter]['page_id'] = isset($val2['page_id']) ? $val2['page_id'] : '';
                            $peopleCard[$indexCounter]['task_id'] = isset($val2['task_id']) ? $val2['task_id'] : '';
                            $peopleCard[$indexCounter]['people_data_id'] = isset($val2['id']) ? $val2['id'] : '';
                            $peopleCard[$indexCounter]['challenge_id'] = $challenge_id;
                            $peopleCard[$indexCounter]['user_id'] = isset($val2['user_id']) ? $val2['user_id'] : '';
                            $peopleCard[$indexCounter]['comment_count'] = $count_comment;

                            $user_id = isset($val2['user_id']) ? $val2['user_id'] : 0;
                            $where = " and people_data_id=" . $people_id;
                            $people_likes = $general->get_AllRowscnt("people_likes", $where);

                            $wheres = " and id=" . $user_id;
                            $user_details = $general->get_Onerow("user_details", $wheres);

                            if (!empty($user_details)) {
                                $peopleCard[$indexCounter]['name'] = isset($user_details['name']) ? $user_details['name'] : '';
                                $peopleCard[$indexCounter]['first_character'] = isset($user_details['name']) ? substr($user_details['name'], 0, 1) : '';
                                $peopleCard[$indexCounter]['user_image'] = isset($user_details['image']) ? $user_details['image'] : '';
                                $peopleCard[$indexCounter]['user_id'] = isset($user_details['id']) ? $user_details['id'] : '';
                            } else {
                                $peopleCard[$indexCounter]['name'] = '';
                                $peopleCard[$indexCounter]['first_character'] = '';
                                $peopleCard[$indexCounter]['user_image'] = '';
                                $peopleCard[$indexCounter]['user_id'] = $user_id;
                            }

                            $peopleCard[$indexCounter]['like_count'] = $people_likes;

                            $challengesDetails = $general->get_Onerow("challenges", " and challenge_id='" . $challenge_id . "'");

                            if (!empty($challengesDetails) && isset($challengesDetails['end_date'])) {
                                $peopleCard[$indexCounter]['complete'] = (strtotime($challengesDetails['end_date']) >= time()) ? "no" : "yes";
                                $peopleCard[$indexCounter]['challenge_title'] = isset($challengesDetails['title']) ? $challengesDetails['title'] : '';
                            } else {
                                $peopleCard[$indexCounter]['complete'] = "no";
                                $peopleCard[$indexCounter]['challenge_title'] = '';
                            }

                            $page = $page_id > 0 ? $general->get_Onerow("page", " and id='" . $page_id . "'") : null;

                            $peopleCard[$indexCounter]['icon'] = !empty($page) && isset($page['icon']) ? $page['icon'] : '';
                            $peopleCard[$indexCounter]['page_title'] = !empty($page) && isset($page['title']) ? $page['title'] : '';
                            $peopleCard[$indexCounter]['end_date'] = isset($val2['created_at']) ? date('d-m-Y', strtotime($val2['created_at'])) : '';

                            // Increment the index for the next unique certificate
                            $indexCounter++;
                        }
                    }
                }
            }

            $data['peopleCard'] = $peopleCard;
            $UserCard = array();

            // Fetch user posts
            if ($userpost_count > 0) {
                $where = " and user_id=" . $user_id;
                $user_post_arr = $general->get_AllRows("user_posts", 0, $userpost_count, "id desc", $where);

                if (is_array($user_post_arr)) {
                    foreach ($user_post_arr as $key => $val) {
                        if (isset($val['id'])) {
                            $count_comment = $general->get_AllRowscnt("user_comments", " and post_id=" . $val['id']);

                            $UserCard[$key] = [];
                            $UserCard[$key]['id'] = $val['id'];
                            $UserCard[$key]['textData'] = isset($val['textData']) ? $general->basedecode($val['textData']) : '';
                            $UserCard[$key]['image'] = isset($val['image']) ? $val['image'] : '';
                            $UserCard[$key]['video'] = isset($val['video']) ? $val['video'] : '';
                            $UserCard[$key]['date'] = isset($val['created_at']) ? date("M d, Y \a\\t g:i A", strtotime($val['created_at'])) : '';
                            $UserCard[$key]['created_at'] = isset($val['created_at'])
                                ? date('Y-m-d H:i:s', strtotime($val['created_at']))
                                : '';
                            $UserCard[$key]['post_id'] = $val['id'];
                            $UserCard[$key]['user_id'] = isset($val['user_id']) ? $val['user_id'] : '';
                            $UserCard[$key]['comment_count'] = $count_comment;

                            $user_id = isset($val['user_id']) ? $val['user_id'] : 0;
                            $where = " and post_id=" . $val['id'];
                            $people_likes = $general->get_AllRowscnt("user_comment_likes", $where);

                            $wheres = " and id=" . $user_id;
                            $user_details = $general->get_Onerow("user_details", $wheres);

                            if (!empty($user_details)) {
                                $UserCard[$key]['name'] = isset($user_details['name']) ? $user_details['name'] : '';
                                $UserCard[$key]['first_character'] = isset($user_details['name']) ? substr($user_details['name'], 0, 1) : '';
                                $UserCard[$key]['user_image'] = isset($user_details['image']) ? $user_details['image'] : '';
                                $UserCard[$key]['user_id'] = isset($user_details['id']) ? $user_details['id'] : '';
                            } else {
                                $UserCard[$key]['name'] = '';
                                $UserCard[$key]['first_character'] = '';
                                $UserCard[$key]['user_image'] = '';
                                $UserCard[$key]['user_id'] = $user_id;
                            }

                            $UserCard[$key]['like_count'] = $people_likes;
                            $UserCard[$key]['end_date'] = isset($val['created_at']) ? date('d-m-Y', strtotime($val['created_at'])) : '';
                        }
                    }
                }
            }

            $data['UserCard'] = $UserCard;
        } else {
            $data['post_count'] = 0;
            $data['friends_count'] = 0;
            $data['following'] = 0;
            $data['followers'] = 0;
            $data['peopleCard'] = [];
            $data['UserCard'] = [];
        }

        echo json_encode($data);
    } else {
        echo json_encode(['error' => 'No Data found']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
