<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $page_id = isset($_GET['page_id']) ? $_GET['page_id'] : null;

    // Initialize an empty array to store data
    $data = array();

    if ($page_id) {
        // Fetch user's post count
        $where = " and page_id=" . $page_id;
        $people_count = $general->get_AllRowscnt("people_data", $where);

        // Track unique challenges per user to prevent duplicates
        $uniqueChallenges = [];

        // If user has posts
        if ($people_count > 0) {
            // Fetch people media
            $people_arr = $general->get_AllRows("people_data", 0, $people_count, "id desc", $where);

            // Iterate through each post
            foreach ($people_arr as $key => $val2) {
                if (!isset($val2['user_id']) || !isset($val2['challenge_id']) || !isset($val2['created_at']) || !isset($val2['id'])) {
                    continue; // Skip if essential data is missing
                }
                
                $user_id = $val2['user_id'];
                $challenge_id = $val2['challenge_id'];

                // Create a unique key based on challenge_id, task_id, user_id, and date
                // This ensures we deduplicate per user, not across all users
                $uniqueKey = $user_id . '_' . $challenge_id . '_' . '_' . date("Y-m-d", strtotime($val2['created_at']));

                $where23 = " AND challenge_id=" . $challenge_id;
                $challenge_details2 = $general->get_Onerow("challenges", $where23);

                // Skip this record if we've already processed an identical certificate for this user
                // OR if the challenge doesn't exist
                if (isset($uniqueChallenges[$uniqueKey]) || empty($challenge_details2)) {
                    continue;
                }

                // Mark this challenge as processed for this user
                $uniqueChallenges[$uniqueKey] = true;

                // Retrieve data from people_media only if it exists
                $val = $general->get_Onerow("people_media", " and people_data_id=" . $val2['id']);
                $count_comment = $general->get_AllRowscnt("comments", " and people_id=" . $val2['id']);
                $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=" . $challenge_id);

                // Create a temporary record
                $tempRecord = [];

                // Check if $val is not empty before accessing its properties
                if (!empty($val) && isset($val['id']) && isset($val['caption']) && isset($val['image'])) {
                    $tempRecord['id'] = $val['id'];
                    $tempRecord['caption'] = $val['caption'];
                    $tempRecord['image'] = $val['image'];
                } else {
                    $tempRecord['image'] = !empty($challenge_media) && isset($challenge_media['media_path']) ? 
                        $challenge_media['media_path'] : '';
                }

                $people_id = $val2['id'];
                $page_id = isset($val2['page_id']) ? $val2['page_id'] : 0;
                
                $tempRecord['date'] = isset($val2['created_at']) ? 
                    date("M d, Y \a\\t g:i A", strtotime($val2['created_at'])) : '';
                $tempRecord['page_id'] = $page_id;
                $tempRecord['task_id'] = isset($val2['task_id']) ? $val2['task_id'] : '';
                $tempRecord['people_data_id'] = $people_id;
                $tempRecord['challenge_id'] = $challenge_id;
                $tempRecord['user_id'] = $user_id;

                $where_likes = " and people_data_id=" . $people_id;
                $people_likes = $general->get_AllRowscnt("people_likes", $where_likes);

                $wheres = " and id=" . $user_id;
                $user_details = $general->get_Onerow("user_details", $wheres);
                
                if (!empty($user_details)) {
                    $tempRecord['name'] = isset($user_details['name']) ? $user_details['name'] : '';
                    $tempRecord['first_character'] = isset($user_details['name']) ? 
                        substr($user_details['name'], 0, 1) : '';
                    $tempRecord['user_image'] = isset($user_details['image']) ? $user_details['image'] : '';
                    $tempRecord['user_id'] = isset($user_details['id']) ? $user_details['id'] : $user_id;
                } else {
                    $tempRecord['name'] = '';
                    $tempRecord['first_character'] = '';
                    $tempRecord['user_image'] = '';
                    $tempRecord['user_id'] = $user_id;
                }
                
                $tempRecord['like_count'] = $people_likes;
                $tempRecord['comment_count'] = $count_comment;

                $challengesDetails = $general->get_Onerow("challenges", " and challenge_id='" . $challenge_id . "'");
                
                if (!empty($challengesDetails)) {
                    if (isset($challengesDetails['end_date']) && strtotime($challengesDetails['end_date']) >= time()) {
                        $tempRecord['complete'] = "no";
                    } else {
                        $tempRecord['complete'] = "yes";
                    }
                    $tempRecord['challenge_title'] = isset($challengesDetails['title']) ? 
                        $challengesDetails['title'] : '';
                } else {
                    $tempRecord['complete'] = "yes";
                    $tempRecord['challenge_title'] = '';
                }
                
                $page_info = $general->get_Onerow("page", " and id='" . $page_id . "'");
                
                $tempRecord['icon'] = !empty($page_info) && isset($page_info['icon']) ? $page_info['icon'] : '';
                $tempRecord['page_title'] = !empty($page_info) && isset($page_info['title']) ? 
                    $page_info['title'] : '';
                $tempRecord['end_date'] = isset($val2['created_at']) ? 
                    date('d-m-Y', strtotime($val2['created_at'])) : '';

                // Check certificate status
                $certificates = $general->get_Onerow("certificates", " and people_data_id=" . $people_id);
                $status = !empty($certificates) && isset($certificates['status']) ? 
                    $certificates['status'] : "inactive";

                // Only add active certificates to the data array
                if ($status == "active") {
                    $data[] = $tempRecord;
                }
            }
        }
    }

    // Output the final data in JSON format
    echo json_encode($data);
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}