<?php
// getTeamApprovals.php - Updated to show only members added by current user or their leader
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    
    if ($user_id !== null) {
        
        // Get team challenges where user is involved (either as leader or member)
        $user_teams_count = $general->get_AllRowscnt("team_members", 
            " and user_id=" . $user_id . " and status='active'");
        
        $approval_data = array();
        
        if ($user_teams_count > 0) {
            $user_teams = $general->get_AllRows("team_members", 0, $user_teams_count, "joined_date desc", 
                " and user_id=" . $user_id . " and status='active'");
            
            foreach ($user_teams as $user_team_record) {
                $challenge_id = $user_team_record['challenge_id'];
                $is_leader = ($user_team_record['is_leader'] === 'yes');
                
                // Get challenge details
                $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $challenge_id);
                if (empty($challenge_details)) continue;
                
                // Find the leader of this team
                $team_leader = $general->get_Onerow("team_members", 
                    " and challenge_id=" . $challenge_id . " and is_leader='yes' and status='active'");
                
                if (empty($team_leader)) continue;
                $leader_id = $team_leader['user_id'];
                
                // Filter members based on who added them:
                // - If current user is leader: show only themselves + members they added
                // - If current user is member: show themselves + their leader + members added by their leader
                
                $members_where = " and challenge_id=" . $challenge_id;
                
                if ($is_leader) {
                    // Leader sees: themselves + members they added
                    $members_where .= " and (user_id=" . $user_id . " OR assigned_user=" . $user_id . ")";
                } else {
                    // Member sees: themselves + leader + members added by leader (not by other members)
                    $members_where .= " and (user_id=" . $user_id . " OR user_id=" . $leader_id . " OR assigned_user=" . $leader_id . ")";
                }
                
                $filtered_members_count = $general->get_AllRowscnt("team_members", $members_where);
                
                if ($filtered_members_count > 0) {
                    $filtered_members = $general->get_AllRows("team_members", 0, $filtered_members_count, "joined_date asc", $members_where);
                    
                    $members_data = array();
                    $approved_count = 0;
                    $pending_count = 0;
                    
                    foreach ($filtered_members as $member) {
                        $user_details = $general->get_Onerow("user_details", " and id=" . $member['user_id']);
                        if (!empty($user_details)) {
                            
                            // Check invitation status
                            $invitation_status = 'approved'; // Leader is auto-approved
                            if ($member['user_id'] != $leader_id) {
                                $invitation = $general->get_Onerow("team_invitations", 
                                    " and challenge_id=" . $challenge_id . " and invitee_id=" . $member['user_id']);
                                
                                if (!empty($invitation)) {
                                    $invitation_status = $invitation['status'];
                                } else {
                                    // Fallback to member status
                                    $invitation_status = ($member['status'] === 'active') ? 'accepted' : 'pending';
                                }
                            }
                            
                            if ($invitation_status === 'accepted' || $invitation_status === 'approved' || $member['status'] === 'active') {
                                $approved_count++;
                            } else {
                                $pending_count++;
                            }
                            
                            // Get who added this member
                            $added_by_name = "System";
                            if ($member['assigned_user']) {
                                $added_by_user = $general->get_Onerow("user_details", " and id=" . $member['assigned_user']);
                                if (!empty($added_by_user)) {
                                    $added_by_name = $added_by_user['name'];
                                }
                            }
                            
                            $member_data = array(
                                'id' => $member['user_id'],
                                'name' => $user_details['name'],
                                'avatar' => !empty($user_details['image']) ? $user_details['image'] : '',
                                'status' => $invitation_status,
                                'is_leader' => $member['is_leader'] === 'yes',
                                'joined_date' => $member['joined_date'],
                                'task_id' => $member['task_id'],
                                'added_by' => $added_by_name,
                                'assigned_user' => $member['assigned_user'],
                                'can_manage' => ($is_leader || $member['assigned_user'] == $user_id) // Can manage if user is leader or added this member
                            );
                            $members_data[] = $member_data;
                        }
                    }
                    
                    // Determine overall challenge status
                    $overall_status = 'waiting';
                    if ($approved_count === count($members_data)) {
                        $overall_status = 'approved';
                    } else if ($pending_count === 0 && $approved_count < count($members_data)) {
                        // Some rejected/declined
                        $overall_status = 'partial';
                    }
                    
                    // Check if challenge is expired (simple check - if past start date)
                    $expires_at = null;
                    if (strtotime($challenge_details['start_date']) > time()) {
                        $expires_at = $challenge_details['start_date'];
                    }
                    
                    // Get challenge media
                    $challenge_media = $general->get_Onerow("challenge_media", " and challenge_id=" . $challenge_id);
                    
                    // Get total team size (all members, not just filtered ones)
                    $total_team_size = $general->get_AllRowscnt("team_members", " and challenge_id=" . $challenge_id . " and status='active'");
                    
                    $approval_item = array(
                        'id' => $user_team_record['id'],
                        'challenge_id' => $challenge_id,
                        'challenge_title' => $challenge_details['title'],
                        'challenge_description' => $general->basedecode($challenge_details['description']),
                        'team_size' => $total_team_size, // Total team size
                        'filtered_team_size' => count($members_data), // Members shown to this user
                        'approved_count' => $approved_count,
                        'pending_count' => $pending_count,
                        'total_members' => count($members_data),
                        'status' => $overall_status,
                        'created_date' => $user_team_record['joined_date'],
                        'image' => !empty($challenge_media) ? $challenge_media['media_path'] : '',
                        'members' => $members_data,
                        'entry_points' => $challenge_details['entry_points'],
                        'reward_points' => $challenge_details['reward_points'],
                        'duration' => $challenge_details['days'],
                        'expires_at' => $expires_at,
                        'start_date' => $challenge_details['start_date'],
                        'end_date' => $challenge_details['end_date'],
                        'is_leader' => $is_leader,
                        'leader_id' => $leader_id,
                        'can_add_members' => $is_leader, // Only leaders can add new members
                        'filter_info' => array(
                            'showing_members_added_by' => $is_leader ? 'You' : 'Your leader',
                            'filter_type' => $is_leader ? 'leader_view' : 'member_view',
                            'description' => $is_leader ? 
                                'Showing yourself and members you added' : 
                                'Showing yourself, your leader, and members added by your leader'
                        )
                    );
                    
                    $approval_data[] = $approval_item;
                }
            }
        }
        
        // Remove duplicates based on challenge_id (in case user appears multiple times)
        $unique_approvals = array();
        $seen_challenges = array();
        
        foreach ($approval_data as $approval) {
            if (!in_array($approval['challenge_id'], $seen_challenges)) {
                $unique_approvals[] = $approval;
                $seen_challenges[] = $approval['challenge_id'];
            }
        }
        
        echo json_encode([
            'success' => true,
            'approvals' => $unique_approvals,
            'total_count' => count($unique_approvals)
        ]);
        
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Missing user_id parameter'
        ]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>