<?php
// getTeamAssignments.php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $challenge_id = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    
    if ($challenge_id && $user_id) {
        
        // Get all task assignments for this challenge
        $assignments_count = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $challenge_id . " and status='active' and task_id IS NOT NULL");
        
        $assignments = array();
        if ($assignments_count > 0) {
            $assignments_arr = $general->get_AllRows("team_members", 0, $assignments_count, "id asc", 
                " and challenge_id=" . $challenge_id . " and status='active' and task_id IS NOT NULL");
            
            foreach ($assignments_arr as $assignment) {
                $user_details = $general->get_Onerow("user_details", " and id=" . $assignment['user_id']);
                $task_details = $general->get_Onerow("tasks", " and task_id=" . $assignment['task_id']);
                
                if (!empty($user_details) && !empty($task_details)) {
                    $assignment_data = array(
                        'task_id' => $assignment['task_id'],
                        'task_name' => $task_details['task_name'],
                        'user_id' => $assignment['user_id'],
                        'user_name' => $user_details['name'],
                        'user_avatar' => $user_details['image'] ?? '',
                        'is_leader' => $assignment['is_leader'] === 'yes',
                        'assigned_date' => $assignment['joined_date']
                    );
                    $assignments[] = $assignment_data;
                }
            }
        }
        
        echo json_encode([
            'success' => true,
            'assignments' => $assignments
        ]);
        
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Missing required parameters'
        ]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>