<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $challenge_id = isset($_GET['challenge_id']) ? $_GET['challenge_id'] : null;
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

    if ($challenge_id !== null && $user_id !== null) {
        
        // Get challenge details
        $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $challenge_id);
        
        if (!empty($challenge_details)) {
            $data = array();
            
            // Basic challenge info
            $data['id'] = $challenge_details['challenge_id'];
            $data['challenge_id'] = $challenge_details['challenge_id'];
            $data['title'] = $challenge_details['title'];
            $data['description'] = $general->basedecode($challenge_details['description']);
            $data['start_date'] = $challenge_details['start_date'];
            $data['end_date'] = $challenge_details['end_date'];
            $data['entry_points'] = $challenge_details['entry_points'];
            $data['reward_points'] = $challenge_details['reward_points'];
            
            // Team-specific fields with null checks
            $data['max_members'] = isset($challenge_details['max_members']) ? $challenge_details['max_members'] : 6;
            $data['min_members'] = isset($challenge_details['min_members']) ? $challenge_details['min_members'] : 2;
            $data['current_members'] = isset($challenge_details['current_members']) ? $challenge_details['current_members'] : 0;
            $data['status'] = isset($challenge_details['team_status']) ? $challenge_details['team_status'] : 'forming';
            
            // Calculate duration
            try {
                $start = new DateTime($challenge_details['start_date']);
                $end = new DateTime($challenge_details['end_date']);
                $duration = $start->diff($end);
                $data['duration'] = $duration->days;
            } catch (Exception $e) {
                $data['duration'] = 30; // default
            }
            
            // Get challenge image
            $challenge_media = $general->get_Onerow("challenge_media", " and challenge_id=" . $challenge_id);
            $data['image'] = !empty($challenge_media) && isset($challenge_media['media_path']) ? $challenge_media['media_path'] : '';
            
            // Get tasks for this challenge
            $tasks_count = $general->get_AllRowscnt("tasks", " and challenge_id=" . $challenge_id . " and active='yes'");
            $tasks_data = array();
            
            if ($tasks_count > 0) {
                $tasks_arr = $general->get_AllRows("tasks", 0, $tasks_count, "task_id asc", " and challenge_id=" . $challenge_id . " and active='yes'");
                
                foreach ($tasks_arr as $task) {
                    $task_data = array(
                        'id' => $task['task_id'],
                        'title' => $task['task_name'],
                        'description' => $general->basedecode($task['description']),
                        'points' => $task['reward_points'],
                        'entry_points' => $task['entry_points'],
                        'task_type' => $task['task_type'],
                        'verification_method' => $task['verification_method']
                    );
                    
                    // Get task media if available
                    $task_media = $general->get_Onerow("task_media", " and task_id=" . $task['task_id']);
                    if (!empty($task_media)) {
                        $task_data['image'] = $task_media['media_path'];
                    }
                    
                    // Add task type specific data
                    if ($task['task_type'] == "stepCounter") {
                        $task_pedometer = $general->get_Onerow("task_pedometer", " and task_id=" . $task['task_id']);
                        if (!empty($task_pedometer)) {
                            $task_data['steps'] = $task_pedometer['steps'];
                            $task_data['direction'] = isset($task_pedometer['direction']) ? $task_pedometer['direction'] : '';
                        }
                    }
                    
                    // Determine estimated time and type based on task details
                    $task_data['estimated_time'] = getEstimatedTime($task['task_type'], $task['reward_points']);
                    $task_data['type'] = getTaskFrequency($task['task_type']);
                    $task_data['icon'] = getTaskIcon($task['task_type']);
                    
                    $tasks_data[] = $task_data;
                }
            }
            $data['tasks'] = $tasks_data;
            
            // Check if user is already a team member
            $user_team_member = $general->get_Onerow("team_members", 
                " and challenge_id=" . $challenge_id . " and user_id=" . $user_id . " and status='active'");
            $data['user_joined'] = !empty($user_team_member);
            $data['is_leader'] = !empty($user_team_member) && isset($user_team_member['is_leader']) && $user_team_member['is_leader'] === 'yes';
            
            // Get current team members
            $team_members_count = $general->get_AllRowscnt("team_members", 
                " and challenge_id=" . $challenge_id . " and status='active'");
            
            $team_members = array();
            if ($team_members_count > 0) {
                $team_members_arr = $general->get_AllRows("team_members", 0, $team_members_count, "joined_date asc", 
                    " and challenge_id=" . $challenge_id . " and status='active'");
                
                foreach ($team_members_arr as $member) {
                    $user_details = $general->get_Onerow("user_details", " and id=" . $member['user_id']);
                    if (!empty($user_details)) {
                        $team_member = array(
                            'id' => $member['user_id'],
                            'name' => isset($user_details['name']) ? $user_details['name'] : '',
                            'avatar' => !empty($user_details['image']) ? $user_details['image'] : '',
                            'is_leader' => isset($member['is_leader']) && $member['is_leader'] === 'yes',
                            'joined_date' => $member['joined_date'],
                            'task_id' => isset($member['task_id']) ? $member['task_id'] : null,
                            'level' => isset($user_details['level']) ? $user_details['level'] : 1
                        );
                        $team_members[] = $team_member;
                    }
                }
            }
            $data['team_members'] = $team_members;
            
            // Get user's friends for assignment - using friends table (both ways)
            $friends_data = array();
            $friend_ids = array(); // To avoid duplicates
            
            // Get friends where current user is the followed_user
            $friends_count1 = $general->get_AllRowscnt("friends", " and followed_user=" . $user_id);
            if ($friends_count1 > 0) {
                $friends_arr1 = $general->get_AllRows("friends", 0, $friends_count1, "id desc", " and followed_user=" . $user_id);
                foreach ($friends_arr1 as $friend) {
                    $friend_ids[] = $friend['following_user'];
                }
            }
            
            // Get friends where current user is the following_user
            $friends_count2 = $general->get_AllRowscnt("friends", " and following_user=" . $user_id);
            if ($friends_count2 > 0) {
                $friends_arr2 = $general->get_AllRows("friends", 0, $friends_count2, "id desc", " and following_user=" . $user_id);
                foreach ($friends_arr2 as $friend) {
                    $friend_ids[] = $friend['followed_user'];
                }
            }
            
            // Remove duplicates and get user details for all friends
            $friend_ids = array_unique($friend_ids);
            
            foreach ($friend_ids as $friend_id) {
                $friend_details = $general->get_Onerow("user_details", " and id=" . $friend_id);
                if (!empty($friend_details)) {
                    $friend_data = array(
                        'id' => $friend_details['id'],
                        'name' => isset($friend_details['name']) ? $friend_details['name'] : '',
                        'avatar' => !empty($friend_details['image']) ? $friend_details['image'] : '',
                        'status' => 'online', // Default status since we don't have real-time status
                        'level' => isset($friend_details['level']) ? $friend_details['level'] : 1
                    );
                    $friends_data[] = $friend_data;
                }
            }
            
            $data['friends'] = $friends_data;
            
            echo json_encode($data);
        } else {
            echo json_encode(['error' => 'Challenge not found']);
        }
    } else {
        echo json_encode(['error' => 'Missing required parameters: challenge_id and user_id']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}

// Helper functions
function getEstimatedTime($task_type, $reward_points) {
    switch ($task_type) {
        case 'stepCounter':
            return '30-45 mins';
        case 'mediaCapture':
        case 'videoCapture':
            return '10-15 mins';
        default:
            if ($reward_points >= 75) {
                return '45-60 mins';
            } elseif ($reward_points >= 50) {
                return '30-45 mins';
            } else {
                return '10-15 mins';
            }
    }
}

function getTaskFrequency($task_type) {
    switch ($task_type) {
        case 'stepCounter':
            return 'Daily';
        case 'mediaCapture':
            return 'Weekly';
        case 'videoCapture':
            return 'Weekly';
        default:
            return 'Daily';
    }
}

function getTaskIcon($task_type) {
    switch ($task_type) {
        case 'stepCounter':
            return '🚶‍♂️';
        case 'mediaCapture':
            return '📷';
        case 'videoCapture':
            return '🎥';
        case 'quiz':
            return '🧠';
        default:
            return '🎯';
    }
}
?>