<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $page_id = isset($_GET['page_id']) ? $_GET['page_id'] : null;
    $district_name = isset($_GET['district']) ? $_GET['district'] : null;

    if ($userId !== null && $page_id !== null) {
        
        // Start with minimal filtering to see if we get any results
        $wheres = " and page_id=" . $page_id;
        
        // First, let's check if there are ANY challenges in this page
        $total_challenges = $general->get_AllRowscnt("challenges", $wheres);
        
        // Add team frequency filter
        $wheres .= " and frequency='team'";
        $team_challenges = $general->get_AllRowscnt("challenges", $wheres);
        
        // Add active filter
        $wheres .= " and active='yes'";
        $active_team_challenges = $general->get_AllRowscnt("challenges", $wheres);
        
        // Add visit filter
        $wheres .= " and visit='no'";
        $visit_filtered = $general->get_AllRowscnt("challenges", $wheres);
        
        // Add arena filter
        $wheres .= " and arena='no'";
        $arena_filtered = $general->get_AllRowscnt("challenges", $wheres);
        
        // Add date filter
        $wheres .= " and end_date >= NOW()";
        $final_count = $general->get_AllRowscnt("challenges", $wheres);
        
        // Get the actual challenges
        $challenge_arr = array();
        if ($final_count > 0) {
            $challenge_arr = $general->get_AllRows("challenges", 0, $final_count, "created_date desc", $wheres);
        }

        $data = array();
        $challenges = array();
        
        // Add debug info to response
        $data['debug'] = array(
            'total_challenges_in_page' => $total_challenges,
            'team_frequency_challenges' => $team_challenges,
            'active_team_challenges' => $active_team_challenges,
            'visit_filtered' => $visit_filtered,
            'arena_filtered' => $arena_filtered,
            'final_count_with_date' => $final_count,
            'where_clause' => $wheres,
            'page_id' => $page_id,
            'user_id' => $userId
        );

        foreach ($challenge_arr as $val) {
            // FIRST CHECK: Skip challenges that user has already joined
            $user_team_member = $general->get_Onerow("team_members", 
                " and challenge_id=" . $val['challenge_id'] . " and user_id=" . $userId . " and status='active'");
            
            // If user has already joined this challenge, skip it
            if (!empty($user_team_member)) {
                continue; // Don't show this challenge to the user
            }
            
            $challenge = array();
            $challenge['id'] = $val['challenge_id'];
            $challenge['challenge_id'] = $val['challenge_id'];
            $challenge['page_id'] = $val['page_id'];
            $challenge['title'] = $val['title'];
            $challenge['description'] = $general->basedecode($val['description']);
            $challenge['challenge_type'] = $val['challenge_type'];
            $challenge['frequency'] = $val['frequency'];
            $challenge['start_date'] = $val['start_date'];
            $challenge['start_time'] = $val['start_time'];
            $challenge['end_date'] = $val['end_date'];
            $challenge['end_time'] = $val['end_time'];
            $challenge['entry_points'] = $val['entry_points'];
            $challenge['reward_points'] = $val['reward_points'];
            $challenge['level'] = $val['level'];
            $challenge['created_by'] = $val['created_by'];
            $challenge['created_date'] = $val['created_date'];
            $challenge['participants_count'] = $val['participants_count'];
            $challenge['removed_date'] = $val['removed_date'];
            $challenge['removed_by'] = $val['removed_by'];
            $challenge['open_for'] = $val['open_for'];
            $challenge['days'] = $val['days'];
            
            // Team-specific fields with null coalescing
            $challenge['max_members'] = isset($val['max_members']) ? $val['max_members'] : 999; // No limit
            $challenge['min_members'] = isset($val['min_members']) ? $val['min_members'] : 1; // Anyone can join
            $challenge['current_members'] = isset($val['current_members']) ? $val['current_members'] : 0;
            $challenge['status'] = isset($val['team_status']) ? $val['team_status'] : 'forming';
            
            // Calculate duration in days
            try {
                $start = new DateTime($val['start_date']);
                $end = new DateTime($val['end_date']);
                $duration = $start->diff($end);
                $challenge['duration'] = $duration->days;
            } catch (Exception $e) {
                $challenge['duration'] = 30; // default
            }
            
            // Determine difficulty based on reward points
            if ($val['reward_points'] >= 500) {
                $challenge['difficulty'] = 'Hard';
            } elseif ($val['reward_points'] >= 200) {
                $challenge['difficulty'] = 'Medium';
            } else {
                $challenge['difficulty'] = 'Easy';
            }

            // Get challenge media - handle if empty
            $challenge_media = $general->get_Onerow("challenge_media", " and challenge_id=" . $val['challenge_id']);
            $challenge['image'] = !empty($challenge_media) && isset($challenge_media['media_path']) ? $challenge_media['media_path'] : '';

            // Get page details - handle if empty
            $page_details = $general->get_Onerow("page", " and id=" . $val['page_id']);
            $challenge['page_title'] = !empty($page_details) && isset($page_details['title']) ? $page_details['title'] : '';
            $challenge['icon'] = !empty($page_details) && isset($page_details['icon']) ? $page_details['icon'] : '';

            // User has NOT joined (we already checked above), so set to false
            $challenge['user_joined'] = false;

            // Get team members with their details
            $team_members_count = $general->get_AllRowscnt("team_members", 
                " and challenge_id=" . $val['challenge_id'] . " and status='active'");
            
            $team_members = array();
            if ($team_members_count > 0) {
                $team_members_arr = $general->get_AllRows("team_members", 0, $team_members_count, "joined_date asc", 
                    " and challenge_id=" . $val['challenge_id'] . " and status='active'");
                
                foreach ($team_members_arr as $member) {
                    $user_details = $general->get_Onerow("user_details", " and id=" . $member['user_id']);
                    if (!empty($user_details)) {
                        $team_member = array(
                            'id' => $member['user_id'],
                            'name' => isset($user_details['name']) ? $user_details['name'] : '',
                            'avatar' => !empty($user_details['image']) ? $user_details['image'] : '',
                            'is_leader' => $member['is_leader'] === 'yes',
                            'joined_date' => $member['joined_date'],
                            'task_id' => $member['task_id'],
                            'level' => isset($user_details['level']) ? $user_details['level'] : 1
                        );
                        $team_members[] = $team_member;
                    }
                }
                
                // Update current_members count (sync with actual data)
                $challenge['current_members'] = count($team_members);
            }
            
            $challenge['team_members'] = $team_members;

            // MODIFIED: Team status logic - NO LIMITS, always open for new members
            // Only check if challenge is completed (past end date)
            if (strtotime($val['end_date']) < time()) {
                $challenge['status'] = 'completed';
            } else {
                // For active challenges, always show as "forming" so new users can join
                if ($challenge['current_members'] >= $challenge['min_members']) {
                    $challenge['status'] = 'active'; // Has minimum members but still accepting more
                } else {
                    $challenge['status'] = 'forming'; // Still looking for minimum members
                }
                // REMOVED: No "full" status - unlimited members can join
            }

            // Single task check
            $single_task_cnt = $general->get_AllRowscnt("tasks", " and challenge_id=" . $val['challenge_id']);
            $challenge['single_task'] = ($single_task_cnt == 1) ? "yes" : "no";

            // Only add challenges that are not completed and user hasn't joined
            if ($challenge['status'] !== 'completed') {
                $challenges[] = $challenge;
            }
        }

        // Sort challenges by status priority (forming first, then active)
        usort($challenges, function ($a, $b) {
            $statusPriority = ['forming' => 1, 'active' => 2, 'completed' => 3];
            $aPriority = isset($statusPriority[$a['status']]) ? $statusPriority[$a['status']] : 4;
            $bPriority = isset($statusPriority[$b['status']]) ? $statusPriority[$b['status']] : 4;
            
            if ($aPriority === $bPriority) {
                // If same status, sort by creation date (newest first)
                return strtotime($b['created_date']) - strtotime($a['created_date']);
            }
            
            return $aPriority - $bPriority;
        });

        $data['challenges'] = $challenges;
        $data['total_count'] = count($challenges);
        $data['available_count'] = count($challenges); // All shown challenges are available to join

        // Get page info
        if ($page_id) {
            $page_info = $general->get_Onerow("page", " and id=" . $page_id);
            if (!empty($page_info)) {
                $data['page_title'] = isset($page_info['title']) ? $page_info['title'] : '';
                $data['page_icon'] = isset($page_info['icon']) ? $page_info['icon'] : '';
            }
        }

        // Add additional info about team challenge policy
        $data['team_policy'] = array(
            'unlimited_members' => true,
            'anyone_can_join' => true,
            'hide_joined_challenges' => true,
            'message' => 'All team challenges are open for new members. Challenges you have already joined are hidden.'
        );

        echo json_encode($data);
    } else {
        echo json_encode(['error' => 'Missing required parameters: userId and page_id']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>