<?php
// getTeamInvitations.php - Works with existing DB structure
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    
    if ($user_id !== null) {
        
        // Get team invitations where user is the invitee (not the leader)
        $invitations_count = $general->get_AllRowscnt("team_invitations", 
            " and invitee_id=" . $user_id);
        
        $invitations_data = array();
        
        if ($invitations_count > 0) {
            $invitations = $general->get_AllRows("team_invitations", 0, $invitations_count, "created_date desc", 
                " and invitee_id=" . $user_id);
            
            foreach ($invitations as $invitation) {
                $challenge_id = $invitation['challenge_id'];
                $inviter_id = $invitation['inviter_id'];
                
                // Get challenge details
                $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $challenge_id);
                if (empty($challenge_details)) continue;
                
                // Get inviter details
                $inviter_details = $general->get_Onerow("user_details", " and id=" . $inviter_id);
                if (empty($inviter_details)) continue;
                
                // Get challenge media
                $challenge_media = $general->get_Onerow("challenge_media", " and challenge_id=" . $challenge_id);
                
                // Get current team size
                $current_members = $general->get_AllRowscnt("team_members", 
                    " and challenge_id=" . $challenge_id . " and status='active'");
                
                // Get user's role in this challenge (check if they're assigned as co-leader)
                $user_member = $general->get_Onerow("team_members", 
                    " and challenge_id=" . $challenge_id . " and user_id=" . $user_id);
                $my_role = 'member';
                if (!empty($user_member) && isset($user_member['is_leader']) && $user_member['is_leader'] === 'yes') {
                    $my_role = 'co-leader';
                }
                
                // Calculate duration
                $duration = isset($challenge_details['days']) ? $challenge_details['days'] : 30;
                try {
                    $start = new DateTime($challenge_details['start_date']);
                    $end = new DateTime($challenge_details['end_date']);
                    $duration = $start->diff($end)->days;
                } catch (Exception $e) {
                    // Use default from challenge details
                }
                
                // Determine difficulty based on reward points
                $difficulty = 'Easy';
                if ($challenge_details['reward_points'] >= 500) {
                    $difficulty = 'Hard';
                } elseif ($challenge_details['reward_points'] >= 200) {
                    $difficulty = 'Medium';
                }
                
                // Get page details for category
                $page_details = $general->get_Onerow("page", " and id=" . $challenge_details['page_id']);
                $category = !empty($page_details) && isset($page_details['type']) ? $page_details['type'] : 'General';
                
                // Check expiry - simple check if challenge has started
                $expires_at = null;
                if ($invitation['status'] === 'pending' && strtotime($challenge_details['start_date']) > time()) {
                    // Set expiry to 1 day before challenge start
                    $expires_at = date('Y-m-d H:i:s', strtotime($challenge_details['start_date']) - (24 * 60 * 60));
                }
                
                $invitation_data = array(
                    'id' => $invitation['id'],
                    'challenge_id' => $challenge_id,
                    'challenge_title' => $challenge_details['title'],
                    'challenge_description' => $general->basedecode($challenge_details['description']),
                    'invited_by' => array(
                        'id' => $inviter_id,
                        'name' => $inviter_details['name'],
                        'avatar' => !empty($inviter_details['image']) ? $inviter_details['image'] : ''
                    ),
                    'team_size' => isset($challenge_details['max_members']) ? $challenge_details['max_members'] : 6,
                    'current_members' => $current_members,
                    'status' => $invitation['status'], // pending, accepted, declined
                    'invited_date' => $invitation['created_date'],
                    'responded_date' => isset($invitation['responded_date']) ? $invitation['responded_date'] : null,
                    'expires_at' => $expires_at,
                    'image' => !empty($challenge_media) ? $challenge_media['media_path'] : '',
                    'entry_points' => $challenge_details['entry_points'],
                    'reward_points' => $challenge_details['reward_points'],
                    'duration' => $duration,
                    'my_role' => $my_role,
                    'difficulty' => $difficulty,
                    'category' => ucfirst($category),
                    'start_date' => $challenge_details['start_date'],
                    'end_date' => $challenge_details['end_date'],
                    'challenge_type' => $challenge_details['challenge_type'],
                    'frequency' => $challenge_details['frequency']
                );
                
                $invitations_data[] = $invitation_data;
            }
        }
        
        // Sort: pending first, then by date
        usort($invitations_data, function($a, $b) {
            if ($a['status'] === 'pending' && $b['status'] !== 'pending') return -1;
            if ($a['status'] !== 'pending' && $b['status'] === 'pending') return 1;
            return strtotime($b['invited_date']) - strtotime($a['invited_date']);
        });
        
        echo json_encode([
            'success' => true,
            'invitations' => $invitations_data,
            'total_count' => count($invitations_data),
            'pending_count' => count(array_filter($invitations_data, function($inv) {
                return $inv['status'] === 'pending';
            }))
        ]);
        
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Missing user_id parameter'
        ]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>