<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $userId = isset($_GET['userId']) ? $_GET['userId'] : null;
    $district_name = isset($_GET['district']) ? $_GET['district'] : null;
    $india = isset($_GET['india']) ? $_GET['india'] : null;
    $where = " and title='" . $district_name. "'";
    $district_details = $general->get_Onerow("districts", $where);
    $where2 = " and id=" . $district_details['page_id'];
    $page_info_id =  $district_details['page_id'];

    $page_info = $general->get_Onerow("page", $where2);
    if ($userId !== null) {
        // Get challenges completed by the user in the past 7 days
        $end_date_condition = " and page_id=$page_info_id and visit='no' and arena='no' AND start_date >= DATE_SUB(NOW(), INTERVAL 2 DAY)";
        $completed_challenges = $general->get_AllRows("user_challenges", 0, 20, "id desc", " AND completed='yes' $end_date_condition");

        $challenge_ids = [];
        $unique_completed_challenges = [];
        foreach ($completed_challenges as $challenge) {
            // Ensure uniqueness of challenges and count the number of completions
            $challenge_id = $challenge['challenge_id'];
            if (!in_array($challenge_id, $challenge_ids)) {
                $challenge_ids[] = $challenge_id;
                $unique_completed_challenges[$challenge_id] = $challenge;
                $unique_completed_challenges[$challenge_id]['completion_count'] = 1;
            } else {
                $unique_completed_challenges[$challenge_id]['completion_count']++;
            }
        }

        // Sort challenges by completion count in descending order
        usort($unique_completed_challenges, function ($a, $b) {
            return $b['completion_count'] - $a['completion_count'];
        });

        $data = [];
        $challenges = [];

        foreach ($unique_completed_challenges as $challenge) {
            $challenge_id = $challenge['challenge_id'];
            $challenge_details = $general->get_Onerow("challenges", " and challenge_id=$challenge_id and frequency <> 'food' AND frequency <> 'experience'");
            $user_challenges = $general->get_Onerow("user_challenges", " AND challenge_id=" . $challenge_id . " and user_id =" . $userId);
            if ($user_challenges != "") {
                $valueTrue = "true";
            } else {
                $valueTrue = "false";
            }
            // Retrieve challenge media
            $challenge_media = $general->get_Onerow("challenge_media", "and challenge_id=$challenge_id");

            $challenge_info = [
                'page_id' => $challenge_details['page_id'],
                'challenge_id' => $challenge_id,
                'title' => $challenge_details['title'],
                'description' => $general->basedecode($challenge_details['description']),
                'challenge_type' => $challenge_details['challenge_type'],
                'start_date' => $challenge_details['start_date'],
                'start_time' => $challenge_details['start_time'],
                'end_date' => $challenge_details['end_date'],
                'end_time' => $challenge_details['end_time'],
                'entry_points' => $challenge_details['entry_points'],
                'frequency' => $challenge_details['frequency'],
                'reward_points' => $challenge_details['reward_points'],
                'level' => $challenge_details['level'],
                'created_by' => $challenge_details['created_by'],
                'created_date' => $challenge_details['created_date'],
                'participants_count' => $challenge_details['participants_count'],
                'removed_date' => $challenge_details['removed_date'],
                'removed_by' => $challenge_details['removed_by'],
                'info_type' => 'challenge',
                'days' => $challenge_details['days'],
                'referral_count' => $challenge_details['referral_count'],
                'user_referral_count' => $general->get_AllRowscnt("referral_history", " AND referrer_user=$userId"),
                'page_title' => $page_info['title'],
                'icon' => $page_info['icon'],
                'image' => $challenge_media['media_path'], // Need to define $challenge_media
                'completed' => $valueTrue,
            ];
            $challenge_info['open_for'] = $val['open_for'];
            $single_task_cnt   = $general->get_AllRowscnt("tasks", " and challenge_id=".$challenge_details['challenge_id']);

            if($single_task_cnt ==1)
            {
                $challenge_info['single_task'] = "yes";
            }
            else
            {
                $challenge_info['single_task'] = "no";

            }
            $challenges[] = $challenge_info;
        }

        // Limit the number of challenges to 20
        $challenges = array_slice($challenges, 0, 20);

        $data['challenges'] = array_values($challenges);;
        $data['state'] = $page_info['title'];

        echo json_encode($data);
    } else {
        echo json_encode(['error' => 'Missing userId parameter']);
    }
} else {
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>
