<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!isset($_GET['user_id']) || !isset($_GET['timeline']) || !isset($_GET['page_id'])) {
        echo json_encode(['error' => 'Missing required parameters']);
        exit;
    }

    $userId = intval($_GET['user_id']);
    $timeline = $_GET['timeline'];
    $pageId = intval($_GET['page_id']);

    $startDate = calculateStartDate($timeline);

    // Fetch count of challenges
    $where = " AND user_id > 0 AND end_date >= '$startDate' AND page_id = $pageId";
    $challengesCount = $general->get_AllRowscnt("rewards_history", $where);
    
    $total_points = 0;
    $usersPoints = [];

    if ($challengesCount > 0) {
        $challenges = $general->get_AllRows("rewards_history", 0, $challengesCount, "end_date ASC", $where);

        // Aggregate points by user
        foreach ($challenges as $val) {
            if (!isset($usersPoints[$val['user_id']])) {
                $usersPoints[$val['user_id']] = 0;
            }
            $usersPoints[$val['user_id']] += $val['reward_points'];
            
            // Calculate total points for the requested user
            if ($val['user_id'] == $userId) {
                $total_points += $val['reward_points'];
            }
        }
    }

    // Sort users based on total points
    arsort($usersPoints);

    // Make sure the user is in the points array even if they have 0 points
    if (!isset($usersPoints[$userId])) {
        $usersPoints[$userId] = 0;
        arsort($usersPoints); // Re-sort after adding
    }

    // Find user's rank
    $rank = 1;
    foreach ($usersPoints as $user => $points) {
        if ($user == $userId) {
            break;
        }
        $rank++;
    }

    $userDetails = $general->get_Onerow("user_details", " AND id = $userId");
    if ($userDetails) {
        $firstCharCapitalized = ucfirst($userDetails['name'][0]);

        $userData = [
            'name' => $userDetails['name'],
            'image' => $userDetails['image'],
            'first_character' => $firstCharCapitalized,
            'user_id' => $userId,
            'total_points' => $total_points,
            'rank' => $rank,
            'total_users' => count($usersPoints) // Added total users count
        ];

        echo json_encode(['success' => true, 'data' => $userData]);
    } else {
        echo json_encode(['error' => 'User not found']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}

function calculateStartDate($timeline)
{
    $startDate = '';
    switch ($timeline) {
        case 'weekly':
            $startDate = date('Y-m-d H:i:s', strtotime('-1 week'));
            break;
        case 'monthly':
            $startDate = date('Y-m-d H:i:s', strtotime('-1 month'));
            break;
        case 'season':
            $startDate = date('Y-m-d H:i:s', strtotime('-4 months'));
            break;
        default:
            $startDate = date('Y-m-d H:i:s', strtotime('-1 week')); // Default to weekly
            break;
    }
    return $startDate;
}
?>