<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'GET')
{
    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
    $test_mode = isset($_GET['test']) ? $_GET['test'] : false;

    if ($user_id !== null || $test_mode)
    {
        $data = array();
        
        if ($test_mode) {
            $where = " and completed='yes'";
            error_log("TEST MODE: Fetching verification tasks for ALL users");
        } else {
            $where = " and user_id=" . $user_id . " and completed='yes'";
            error_log("NORMAL MODE: Fetching verification tasks for user_id: " . $user_id);
        }

        $task = array();
       
        $user_tasks_cnt = $general->get_AllRowscnt("user_tasks", $where);
        
        error_log("User tasks count for verification: " . $user_tasks_cnt);
        
        if ($user_tasks_cnt > 0)
        {
            $limit = $test_mode ? 20 : $user_tasks_cnt;
            $user_tasks_arr = $general->get_AllRows("user_tasks", 0, $limit, "id desc", $where);

            foreach ($user_tasks_arr as $key => $val)
            {
                try {
                    $challenge_array = array();
                    $page_array = array();
                    
                    // Get challenge details
                    $challenges_arr = $general->get_Onerow("challenges", "and challenge_id =" . $val['challenge_id']);
                    if (empty($challenges_arr)) {
                        error_log("Challenge not found for challenge_id: " . $val['challenge_id']);
                        continue;
                    }
                    
                    $page_details = $general->get_Onerow("page", "and id =" . $challenges_arr['page_id']);
                    if (empty($page_details)) {
                        error_log("Page not found for page_id: " . $challenges_arr['page_id']);
                        continue;
                    }
                    
                    // Get task details
                    $task_details = $general->get_Onerow("tasks", "and task_id =" . $val['task_id']);
                    if (empty($task_details)) {
                        error_log("Task not found for task_id: " . $val['task_id']);
                        continue;
                    }

                    // ENHANCED: Calculate remaining tasks in this challenge for this user
                    $challenge_id = $val['challenge_id'];
                    $current_user_id = $test_mode ? $val['user_id'] : $user_id;
                    
                    // Get total tasks in this challenge
                    $total_tasks_where = " and challenge_id=" . $challenge_id;
                    $total_tasks_count = $general->get_AllRowscnt("tasks", $total_tasks_where);
                    
                    // Get completed tasks by this user in this challenge
                    $completed_tasks_where = " and user_id=" . $current_user_id . " and challenge_id=" . $challenge_id . " and completed='yes'";
                    $completed_tasks_count = $general->get_AllRowscnt("user_tasks", $completed_tasks_where);
                    
                    // Calculate remaining tasks
                    $remaining_tasks = $total_tasks_count - $completed_tasks_count;
                    
                    // Check if user has any pending/active tasks in this challenge
                    $pending_tasks_where = " and user_id=" . $current_user_id . " and challenge_id=" . $challenge_id . " and completed='no'";
                    $pending_tasks_count = $general->get_AllRowscnt("user_tasks", $pending_tasks_where);
                    
                    // Check if challenge is still active
                    $challenge_end_date = strtotime($challenges_arr['end_date'] . ' ' . $challenges_arr['end_time']);
                    $current_time = time();
                    $is_challenge_active = $current_time < $challenge_end_date;
                    
                    // Check if user has completed the entire challenge
                    $user_challenge_where = " and user_id=" . $current_user_id . " and challenge_id=" . $challenge_id . " and completed='yes'";
                    $user_challenge_completed = $general->get_AllRowscnt("user_challenges", $user_challenge_where);

                    // Get user details for test mode
                    if ($test_mode) {
                        $user_details = $general->get_Onerow("user_details", "and id =" . $val['user_id']);
                        $user_name = $user_details ? $user_details['name'] : 'Unknown User';
                    }

                    $task[$key]['page_id'] = $challenges_arr['page_id'];
                    $task[$key]['challenge_id'] = $challenges_arr['challenge_id'];
                    $task[$key]['task_id'] = $val['task_id'];
                    $task[$key]['user_task_id'] = $val['id'];
                    $task[$key]['user_id'] = $val['user_id'];
                    $task[$key]['task_name'] = $task_details['task_name'];
                    $task[$key]['challenge_type'] = $challenges_arr['challenge_type'];
                    $task[$key]['frequency'] = $challenges_arr['frequency'];
                    $task[$key]['start_date'] = $challenges_arr['start_date'];
                    $task[$key]['start_time'] = $challenges_arr['start_time'];
                    $task[$key]['end_date'] = $challenges_arr['end_date'];
                    $task[$key]['end_time'] = $challenges_arr['end_time'];
                    $task[$key]['entry_points'] = $challenges_arr['entry_points'];
                    $task[$key]['reward_points'] = $val['reward_points'];
                    $task[$key]['created_date'] = $challenges_arr['created_date'];
                    $task[$key]['created_by'] = $challenges_arr['created_by'];
                    $task[$key]['description'] = $general->basedecode($challenges_arr['description']);
                    
                    // ENHANCED: Add challenge progress information
                    $task[$key]['total_tasks'] = $total_tasks_count;
                    $task[$key]['completed_tasks'] = $completed_tasks_count;
                    $task[$key]['remaining_tasks'] = $remaining_tasks;
                    $task[$key]['pending_tasks'] = $pending_tasks_count;
                    $task[$key]['is_challenge_active'] = $is_challenge_active;
                    $task[$key]['challenge_completed'] = $user_challenge_completed > 0;
                    $task[$key]['can_continue_challenge'] = $remaining_tasks > 0 && $is_challenge_active && $user_challenge_completed == 0;
                    
                    // Add user name for test mode
                    if ($test_mode) {
                        $task[$key]['user_name'] = $user_name;
                    }
                    
                    // Determine verification status based on existing columns
                    // UPDATED: Include 'nill' as completed since auto-approved tasks don't need verification
                    if ($val['approved'] == 'yes' || $val['approved'] == 'nill') {
                        $verification_status = 'completed';
                    } elseif ($val['rejected'] == 'yes') {
                        $verification_status = 'rejected';
                    } else {
                        // Task is completed but not yet approved/rejected = under verification
                        $verification_status = 'under_verification';
                    }
                    
                    $task[$key]['verification_status'] = $verification_status;
                    $task[$key]['submitted_date'] = $val['end_date'];
                    $task[$key]['completion_date'] = $val['end_date'];
                    $task[$key]['steps'] = $val['steps'];
                    $task[$key]['approved_by'] = $val['approved_by'] ?? null;
                    
                    // For rejected tasks, add rejection reason if available
                    $task[$key]['rejection_reason'] = $val['rejection_reason'] ?? 'Task was rejected. Please try again.';
                    
                    $challenge_array['challenge_id'] = $challenges_arr['challenge_id'];
                    $page_array['image'] = $page_details['icon'];
                    $page_array['title'] = $page_details['title'];
                    $page_array['banner'] = $page_details['banner'];
                    $task[$key]['challenge'] = $challenge_array;
                    $task[$key]['selectedMovie'] = $page_array;
                    $task[$key]['challenge_title'] = $challenges_arr['title'];

                    // Get challenge media
                    $task_image_arr = $general->get_Onerow("challenge_media", "and challenge_id =" . $val['challenge_id']);
                    $task[$key]['image'] = $task_image_arr['media_path'] ?? '';
                    
                    // Calculate time in verification (for under_verification status)
                    if ($verification_status == 'under_verification') {
                        $submitted_time = strtotime($val['end_date']);
                        $current_time = time();
                        $hours_in_verification = floor(($current_time - $submitted_time) / 3600);
                        $task[$key]['hours_in_verification'] = $hours_in_verification;
                    }
                    
                    // Count how many times this task was attempted
                    $task[$key]['attempts_count'] = $general->get_AllRowscnt("user_tasks", " and user_id=" . $current_user_id . " and task_id=" . $val['task_id']);
                    
                } catch (Exception $e) {
                    error_log("Error processing verification task: " . $e->getMessage());
                    continue;
                }
            }
            
            // Filter out empty entries and reindex array
            $task = array_values(array_filter($task));
            
            // Add test mode info to response
            if ($test_mode) {
                $data['test_mode'] = true;
                $data['total_tasks_found'] = $user_tasks_cnt;
                $data['showing_tasks'] = count($task);
                $data['note'] = 'Test mode: Showing verification tasks from all users';
            }
            
            $data['tasks'] = $task;
            echo json_encode($data);
        }
        else
        {
            $response = array(
                'error' => $test_mode ? 'No verification tasks found in system' : 'No verification tasks found for user',
                'test_mode' => $test_mode,
                'query_info' => array(
                    'where_clause' => $where,
                    'user_id' => $user_id,
                    'tasks_count' => $user_tasks_cnt
                )
            );
            echo json_encode($response);
        }
    }
    else
    {
        echo json_encode(['error' => 'Missing user_id parameter. Add ?user_id=X or ?test=true for testing']);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>