<?php
// respondToInvitation.php - Works with existing DB structure
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $invitation_id = isset($_POST['invitation_id']) ? $_POST['invitation_id'] : null;
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : null;
    $response = isset($_POST['response']) ? $_POST['response'] : null; // 'accept' or 'decline'
    
    if ($invitation_id !== null && $user_id !== null && $response !== null) {
        
        try {
            // Get invitation details
            $invitation = $general->get_Onerow("team_invitations", " and id=" . $invitation_id);
            if (empty($invitation)) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Invitation not found'
                ]);
                exit;
            }
            
            // Verify the invitation belongs to this user
            if ($invitation['invitee_id'] != $user_id) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Unauthorized: This invitation does not belong to you'
                ]);
                exit;
            }
            
            // Check if already responded
            if ($invitation['status'] !== 'pending') {
                echo json_encode([
                    'success' => false,
                    'error' => 'Invitation has already been responded to'
                ]);
                exit;
            }
            
            // Check if invitation has expired
            $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $invitation['challenge_id']);
            if (empty($challenge_details)) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Challenge not found'
                ]);
                exit;
            }
            
            // Check if challenge has already started
            if (strtotime($challenge_details['start_date']) <= time()) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Challenge has already started'
                ]);
                exit;
            }
            
            $new_status = ($response === 'accept') ? 'accepted' : 'declined';
            
            // Update invitation status
            $update_result = $general->upd_Row(
                'team_invitations',
                "status='$new_status', responded_date=NOW()",
                "id='$invitation_id'"
            );
            
            if ($update_result !== "") {
                echo json_encode([
                    'success' => false,
                    'error' => 'Failed to update invitation status: ' . $update_result
                ]);
                exit;
            }
            
            if ($response === 'accept') {
                // User accepted - activate their team membership
                $member_update = $general->upd_Row(
                    'team_members',
                    "status='active'",
                    "challenge_id='" . $invitation['challenge_id'] . "' AND user_id='$user_id'"
                );
                
                if ($member_update !== "") {
                    echo json_encode([
                        'success' => false,
                        'error' => 'Failed to activate team member: ' . $member_update
                    ]);
                    exit;
                }
                
                // Add user to user_challenges table if not exists
                $user_challenge_exists = $general->get_Onerow("user_challenges", 
                    " and challenge_id=" . $invitation['challenge_id'] . " and user_id=" . $user_id);
                
                if (empty($user_challenge_exists)) {
                    $user_challenge_result = $general->ins_Row(
                        'user_challenges',
                        'challenge_id, user_id, start_date, reward_points, arena, page_id, completed, visit, team_challenge',
                        "'" . $invitation['challenge_id'] . "', '$user_id', NOW(), '0', 'no', '" . $challenge_details['page_id'] . "', 'no', 'no', 'yes'"
                    );
                    
                    if ($user_challenge_result !== "") {
                        // Log error but don't fail the acceptance
                        error_log("Failed to add user_challenge record: " . $user_challenge_result);
                    }
                }
                
                // Update challenge member count
                $current_active_members = $general->get_AllRowscnt("team_members", 
                    " and challenge_id=" . $invitation['challenge_id'] . " and status='active'");
                
                $challenge_update = $general->upd_Row(
                    'challenges',
                    "current_members='$current_active_members'",
                    "challenge_id='" . $invitation['challenge_id'] . "'"
                );
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Invitation accepted successfully',
                    'status' => 'accepted',
                    'challenge_id' => $invitation['challenge_id']
                ]);
                
            } else {
                // User declined - mark member as declined
                $member_update = $general->upd_Row(
                    'team_members',
                    "status='declined'",
                    "challenge_id='" . $invitation['challenge_id'] . "' AND user_id='$user_id'"
                );
                
                // Update challenge member count
                $current_active_members = $general->get_AllRowscnt("team_members", 
                    " and challenge_id=" . $invitation['challenge_id'] . " and status='active'");
                
                $challenge_update = $general->upd_Row(
                    'challenges',
                    "current_members='$current_active_members'",
                    "challenge_id='" . $invitation['challenge_id'] . "'"
                );
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Invitation declined',
                    'status' => 'declined'
                ]);
            }
            
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'error' => 'Database error: ' . $e->getMessage()
            ]);
        }
        
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Missing required parameters: invitation_id, user_id, or response'
        ]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $invitation_id = isset($_POST['invitation_id']) ? $_POST['invitation_id'] : null;
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : null;
    $response = isset($_POST['response']) ? $_POST['response'] : null; // 'accept' or 'decline'
    
    if ($invitation_id !== null && $user_id !== null && $response !== null) {
        
        try {
            // Get invitation details
            $invitation = $general->get_Onerow("team_invitations", " and id=" . $invitation_id);
            if (empty($invitation)) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Invitation not found'
                ]);
                exit;
            }
            
            // Verify the invitation belongs to this user
            if ($invitation['invitee_id'] != $user_id) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Unauthorized: This invitation does not belong to you'
                ]);
                exit;
            }
            
            // Check if already responded
            if ($invitation['status'] !== 'pending') {
                echo json_encode([
                    'success' => false,
                    'error' => 'Invitation has already been responded to'
                ]);
                exit;
            }
            
            // Check if invitation has expired
            $challenge_details = $general->get_Onerow("challenges", " and challenge_id=" . $invitation['challenge_id']);
            if (empty($challenge_details)) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Challenge not found'
                ]);
                exit;
            }
            
            // Check if challenge has already started
            if (strtotime($challenge_details['start_date']) <= time()) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Challenge has already started'
                ]);
                exit;
            }
            
            $new_status = ($response === 'accept') ? 'accepted' : 'declined';
            
            // Update invitation status
            $update_result = $general->upd_Row(
                'team_invitations',
                "status='$new_status', responded_date=NOW()",
                "id='$invitation_id'"
            );
            
            if ($update_result !== "") {
                echo json_encode([
                    'success' => false,
                    'error' => 'Failed to update invitation status: ' . $update_result
                ]);
                exit;
            }
            
            if ($response === 'accept') {
                // User accepted - they're already in team_members table, just need to activate
                // Check if user is already in team_members
                $existing_member = $general->get_Onerow("team_members", 
                    " and challenge_id=" . $invitation['challenge_id'] . " and user_id=" . $user_id);
                
                if (empty($existing_member)) {
                    echo json_encode([
                        'success' => false,
                        'error' => 'Team member record not found'
                    ]);
                    exit;
                }
                
                // Activate the member (they were added when challenge was created but may have been inactive)
                $member_update = $general->upd_Row(
                    'team_members',
                    "status='active'",
                    "challenge_id='" . $invitation['challenge_id'] . "' AND user_id='$user_id'"
                );
                
                if ($member_update !== "") {
                    echo json_encode([
                        'success' => false,
                        'error' => 'Failed to activate team member: ' . $member_update
                    ]);
                    exit;
                }
                
                // Add user to user_challenges table
                $user_challenge_exists = $general->get_Onerow("user_challenges", 
                    " and challenge_id=" . $invitation['challenge_id'] . " and user_id=" . $user_id);
                
                if (empty($user_challenge_exists)) {
                    $user_challenge_result = $general->ins_Row(
                        'user_challenges',
                        'challenge_id, user_id, start_date, reward_points, arena, page_id, completed, visit, team_challenge',
                        "'" . $invitation['challenge_id'] . "', '$user_id', NOW(), '0', 'no', '" . $challenge_details['page_id'] . "', 'no', 'no', 'yes'"
                    );
                    
                    if ($user_challenge_result !== "") {
                        // Log error but don't fail the acceptance
                        error_log("Failed to add user_challenge record: " . $user_challenge_result);
                    }
                }
                
                // Update challenge member count
                $current_active_members = $general->get_AllRowscnt("team_members", 
                    " and challenge_id=" . $invitation['challenge_id'] . " and status='active'");
                
                $challenge_update = $general->upd_Row(
                    'challenges',
                    "current_members='$current_active_members'",
                    "challenge_id='" . $invitation['challenge_id'] . "'"
                );
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Invitation accepted successfully',
                    'status' => 'accepted',
                    'challenge_id' => $invitation['challenge_id']
                ]);
                
            } else {
                // User declined - remove from team_members or mark as inactive
                $member_update = $general->upd_Row(
                    'team_members',
                    "status='declined'",
                    "challenge_id='" . $invitation['challenge_id'] . "' AND user_id='$user_id'"
                );
                
                // Update challenge member count
                $current_active_members = $general->get_AllRowscnt("team_members", 
                    " and challenge_id=" . $invitation['challenge_id'] . " and status='active'");
                
                $challenge_update = $general->upd_Row(
                    'challenges',
                    "current_members='$current_active_members'",
                    "challenge_id='" . $invitation['challenge_id'] . "'"
                );
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Invitation declined',
                    'status' => 'declined'
                ]);
            }
            
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'error' => 'Database error: ' . $e->getMessage()
            ]);
        }
        
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Missing required parameters: invitation_id, user_id, or response'
        ]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>