<?php
require_once("cors.php");
require_once("includes/general.class.php");
error_reporting(E_ALL);
ini_set('display_errors', 1);

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST')
{
    // Validate required fields
    $requiredFields = ['stateCode', 'constituency', 'page_id', 'user_id'];
    $errors = array();
    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field]) || empty($_POST[$field])) {
            $errors[] = "Missing required field: $field";
        }
    }

    if (empty($errors))
    {
        // Extract POST data
        $stateCode = $_POST['stateCode'];
        $constituency = $_POST['constituency'];
        $page_id = $_POST['page_id'];
        $user_id = $_POST['user_id'];

        // Attempt to insert data into the database
        $msg = $general->ins_Row(
            'user_constituency',
            'stateCode, user_id, page_id, constituency',
            "'$stateCode', '$user_id', '$page_id', '$constituency'"
        );

        if (empty($msg))
        {
            // Successful insertion
            echo json_encode(['success' => true]);
        }
        else
        {
            // Database operation failed
            echo json_encode(['error' => $msg]);
        }
    }
    else
    {
        // Missing required fields
        echo json_encode(['error' => $errors]);
    }
}
else
{
    // Invalid request method
    echo json_encode(['error' => 'Invalid request method']);
}
?>
