<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieving data from POST request
    $userTaskId = $_POST['userTaskId'];
    $challenge_id = $_POST['challenge_id'];
    $userId = $_POST['userId'];
    
    if (isset($_POST['steps'])) {
        $steps = $_POST['steps'];
    } else {
        $steps = 0;
    }

    $task_id = isset($_POST['task_id']) ? $_POST['task_id'] : null;
    $end_date = date('Y-m-d H:i:s');
    $end_time = date('H:i:s');

    // Get user task details
    $user_task = $general->get_Onerow("user_tasks", " and id=" . $userTaskId);
    if (empty($user_task)) {
        echo json_encode(['error' => 'User task not found']);
        exit;
    }

    // Get challenge information to check if it's a team challenge
    $challenge_info = $general->get_Onerow("challenges", " and challenge_id=" . $challenge_id);
    $is_team_challenge = ($challenge_info['frequency'] === 'team' || $user_task['team_challenge'] === 'yes');

    // Get all tasks for this challenge
    $allTasksWhereClause = " and challenge_id=" . $challenge_id;
    $totalTasksCount = $general->get_AllRowscnt("tasks", $allTasksWhereClause);
    $allTasksList = $general->get_AllRows("tasks", 0, $totalTasksCount, "task_id desc", $allTasksWhereClause);

    // Get completed tasks for this user and challenge
    $completedTasksWhereClause = " and user_id=" . $userId . " and challenge_id=" . $challenge_id . " and completed='yes'";
    $completedTasksCount = $general->get_AllRowscnt("user_tasks", $completedTasksWhereClause);

    $endyes = 'no';

    // For individual challenges, check if all tasks are completed
    // For team challenges, this task completion doesn't necessarily mean challenge completion
    if (!$is_team_challenge && $completedTasksCount >= $totalTasksCount) {
        $endyes = 'yes';
    }

    $end = isset($_POST['end']) ? $_POST['end'] : $endyes;

    // Update user task completion
    $yes = "yes";
    $msg = $general->upd_Row(
        "user_tasks", 
        "steps='" . $steps . "',end_date='" . $end_date . "',completed='" . $yes . "',end_time='" . $end_time . "'", 
        "id=" . $userTaskId
    );

    // Clean up pending/rejected tasks
    $user_where = " and user_id=$userId and approved='no' and rejected = 'no'";
    $user_task_cnt = $general->get_AllRowscnt("user_tasks", $user_where);
    if ($user_task_cnt > 0) {
        $user_task_arr = $general->get_AllRows("user_tasks", 0, $user_task_cnt, "id desc", $user_where);
        foreach ($user_task_arr as $key => $val) {
            $general->del_Row("user_tasks", " id=" . $val['id']);
        }
    }

    // Handle team challenge completion logic
    if ($is_team_challenge) {
        // Update team member task status
        $team_update = $general->upd_Row(
            'team_members',
            "task_status='completed'",
            "challenge_id='$challenge_id' AND user_id='$userId' AND task_id='$task_id'"
        );

        // Check if all team members have completed their tasks
        $total_team_members = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $challenge_id . " and status='active'");
        
        $completed_team_members = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $challenge_id . " and status='active' and task_status='completed'");

        // If all team members completed, mark the entire challenge as completed for all team members
        if ($total_team_members === $completed_team_members) {
            $end = 'yes'; // Override end status for team completion
            
            // Update challenge status
            $general->upd_Row(
                'challenges',
                "team_status='completed'",
                "challenge_id='$challenge_id'"
            );

            // Mark challenge complete for all team members
            $challenge_complete = $general->upd_Row(
                'user_challenges',
                "end_date='$end_date', completed='yes', end_time='$end_time'",
                "challenge_id='$challenge_id' AND team_challenge='yes'"
            );
        }
    }

    // Handle challenge completion (both individual and team)
    if ($end == "yes") {
        $wheres = " and challenge_id=" . $challenge_id;
        $wheres2 = " and task_id=" . $task_id;
        $challenges = $general->get_Onerow("challenges", $wheres);
        $tasks_table = $general->get_Onerow("tasks", $wheres2);
        $reward_points = $tasks_table['reward_points'];
        $arena = $challenges['arena'];
        $page_ids = $challenges['page_id'];
        $where2 = " and user_id = " . $userId . " and challenge_id=" . $challenge_id;
        $user_tasks = $general->get_Onerow("user_tasks", $where2);

        // Update user_challenges for individual challenges or when team is complete
        if (!$is_team_challenge) {
            // Individual challenge completion logic
            if ($challenges['frequency'] != "streak") {
                $msg2 = $general->upd_Row(
                    "user_challenges", 
                    "end_date='$end_date', completed='$yes', end_time='$end_time'", 
                    "challenge_id=" . $challenge_id . " and user_id=" . $userId
                );
            } elseif ($challenges['frequency'] == "streak") {
                $start_date = new DateTime($user_tasks['start_date']);
                $today = new DateTime();
                $interval = $start_date->diff($today);
                $days_difference = $interval->days;
                if ($challenges['days'] == $days_difference) {
                    $msg2 = $general->upd_Row(
                        "user_challenges", 
                        "end_date='$end_date', completed='$yes', end_time='$end_time'", 
                        "challenge_id=" . $challenge_id . " and user_id=" . $userId
                    );
                }
            }
        }
        // For team challenges, user_challenges is updated above when entire team completes

        if ($challenges['frequency'] == "challenges") {
            $status = "completed";
        } else {
            $status = "pending";
        }

        $page_id = $challenges['page_id'];
        $reward_points = $tasks_table['reward_points'];
        
        // Create people_data entry
        $msg = $general->ins_Row(
            'people_data',
            'user_id, task_id, challenge_id, page_id',
            "'$userId', '$task_id', '$challenge_id', '$page_id'"
        );
        $people_data_id = $general->get_insetId();

        if ($challenges['frequency'] != "contest") {
            // Create certificate
            $msg4 = $general->ins_Row(
                'certificates',
                'challenge_id, page_id, user_id, end_date, people_data_id, task_id',
                "'$challenge_id', '$page_id', '$userId', '$end_date', '$people_data_id', '$task_id'"
            );

            // Create rewards history
            $msg3 = $general->ins_Row(
                'rewards_history',
                'challenge_id, page_id, reward_points, status, user_id, end_date',
                "'$challenge_id', '$page_id','$reward_points','$status','$userId','$end_date'"
            );

            // Handle rewards
            if ($challenges['rewards'] == "yes") {
                $get_rewards = $general->get_Onerow("rewards", " and challenge_id=" . $challenges['challenge_id']);
                if (!empty($get_rewards)) {
                    $reward_id = $get_rewards['id'];
                    $msg5 = $general->ins_Row(
                        'my_rewards',
                        'challenge_id, page_id, user_id, reward_id',
                        "'$challenge_id', '$page_id', '$userId', '$reward_id'"
                    );
                }
            }

            // Handle XP system
            $xp_bank_data = $general->get_Onerow("xp_bank", " and user_id=" . $userId . " and page_id=" . $page_id);

            if (!empty($xp_bank_data)) {
                $xp = $reward_points + $xp_bank_data['total_xp'];
                $msg3 = $general->ins_Row(
                    'xp_history',
                    'challenge_id, page_id, xp, user_id',
                    "'$challenge_id', '$page_id','$reward_points','$userId'"
                );
                $msg2 = $general->upd_Row("xp_bank", "total_xp='$xp'", "id=" . $xp_bank_data['id']);
            } else {
                $xp = $reward_points;
                $msg3 = $general->ins_Row(
                    'xp_history',
                    'challenge_id, page_id, xp, user_id',
                    "'$challenge_id', '$page_id','$xp','$userId'"
                );
                $msg3 = $general->ins_Row(
                    'xp_bank',
                    'page_id, total_xp, user_id',
                    "'$page_id','$xp','$userId'"
                );
            }
        }
    }

    // Prepare response
    $response = array(
        'success' => true,
        'message' => $end,
        'is_team_challenge' => $is_team_challenge
    );

    // Add team-specific information if applicable
    if ($is_team_challenge) {
        $total_team_members = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $challenge_id . " and status='active'");
        
        $completed_team_members = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $challenge_id . " and status='active' and task_status='completed'");

        $response['team_progress'] = array(
            'total_members' => $total_team_members,
            'completed_members' => $completed_team_members,
            'team_completed' => ($total_team_members === $completed_team_members)
        );

        if ($response['team_progress']['team_completed']) {
            $response['team_message'] = 'Congratulations! Your entire team has completed the challenge!';
        } else {
            $response['team_message'] = 'Great job! Waiting for other team members to complete their tasks.';
        }
    }

    if (empty($msg) && empty($msg2)) {
        echo json_encode($response);
    } else {
        echo json_encode(['error' => 'User progress not saved']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>