<?php
require_once("cors.php");
require_once("includes/general.class.php");

$general = new general();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieving data from POST request
    $userTaskId = isset($_POST['userTaskId']) ? $_POST['userTaskId'] : null;
    $steps = isset($_POST['steps']) ? $_POST['steps'] : 0;
    
    if ($userTaskId === null) {
        echo json_encode(['error' => 'Missing userTaskId parameter']);
        exit;
    }

    // Get user task details to check if it's a team challenge
    $user_task = $general->get_Onerow("user_tasks", " and id=" . $userTaskId);
    
    if (empty($user_task)) {
        echo json_encode(['error' => 'User task not found']);
        exit;
    }

    // Check if this is a team challenge
    $challenge_info = $general->get_Onerow("challenges", " and challenge_id=" . $user_task['challenge_id']);
    $is_team_challenge = ($challenge_info['frequency'] === 'team' || $user_task['team_challenge'] === 'yes');

    // Update steps in user_tasks
    $msg = $general->upd_Row(
        "user_tasks", 
        "steps='" . $steps . "'", 
        "id=" . $userTaskId
    );

    // For team challenges, optionally update team member progress status
    if ($is_team_challenge && !empty($msg) === false) {
        // Determine progress status based on steps or other criteria
        $progress_status = 'in_progress';
        
        // You can add logic here to determine when to update task_status
        // For example, if steps reach a certain threshold
        $task_info = $general->get_Onerow("tasks", " and task_id=" . $user_task['task_id']);
        
        if (!empty($task_info) && isset($task_info['task_type']) && $task_info['task_type'] === 'stepCounter') {
            $pedometer_info = $general->get_Onerow("task_pedometer", " and task_id=" . $user_task['task_id']);
            
            if (!empty($pedometer_info) && $steps >= $pedometer_info['steps']) {
                // Steps goal reached, update team member status
                $team_update = $general->upd_Row(
                    'team_members',
                    "task_status='completed'",
                    "challenge_id='" . $user_task['challenge_id'] . "' AND user_id='" . $user_task['user_id'] . "' AND task_id='" . $user_task['task_id'] . "'"
                );
            } else {
                // Still in progress
                $team_update = $general->upd_Row(
                    'team_members',
                    "task_status='in_progress'",
                    "challenge_id='" . $user_task['challenge_id'] . "' AND user_id='" . $user_task['user_id'] . "' AND task_id='" . $user_task['task_id'] . "'"
                );
            }
        }
    }

    $response = array(
        'success' => true,
        'message' => 'Progress updated',
        'is_team_challenge' => $is_team_challenge,
        'steps_updated' => $steps
    );

    // Add team-specific progress information
    if ($is_team_challenge) {
        // Get team progress for context
        $total_team_members = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $user_task['challenge_id'] . " and status='active'");
        
        $completed_team_members = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $user_task['challenge_id'] . " and status='active' and task_status='completed'");
        
        $in_progress_members = $general->get_AllRowscnt("team_members", 
            " and challenge_id=" . $user_task['challenge_id'] . " and status='active' and task_status='in_progress'");

        $response['team_progress'] = array(
            'total_members' => $total_team_members,
            'completed_members' => $completed_team_members,
            'in_progress_members' => $in_progress_members,
            'not_started_members' => $total_team_members - $completed_team_members - $in_progress_members
        );

        // Check if this user's progress affects team status
        if (!empty($task_info) && $task_info['task_type'] === 'stepCounter') {
            $pedometer_info = $general->get_Onerow("task_pedometer", " and task_id=" . $user_task['task_id']);
            if (!empty($pedometer_info)) {
                $response['step_progress'] = array(
                    'current_steps' => $steps,
                    'target_steps' => $pedometer_info['steps'],
                    'progress_percentage' => min(100, round(($steps / $pedometer_info['steps']) * 100))
                );
            }
        }
    }
    
    if (empty($msg)) {
        echo json_encode($response);
    } else {
        echo json_encode(['error' => 'User progress not saved', 'details' => $msg]);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}
?>